#ifndef _VUCOLOURSPEC_H_
#define  _VUCOLOURSPEC_H_

#include "vuColour.h"

static float CXFSPECtoRGB[3][3] = {
  {-4.6760940e-01,   1.0060528e+01,   1.1281898e+00},
  {-5.9800888e-01,   1.1977012e+01,  -6.7873892e-01},
  { 1.4143822e+01,  -2.1922645e+00,  -1.1837713e+00}
};

static float CXF31toSPEC[3][31] = {
  { 0.0541431830, 0.0696043380, 0.0829170700, 0.0812685130, 0.0779988200, 0.0754269200,
    0.0686281460, 0.0626345010, 0.0567715030, 0.0516375260, 0.0468861630, 0.0412096450,
    0.0352371240, 0.0292843220, 0.0237363350, 0.0190178730, 0.0153168740, 0.0121851310,
    0.0091389738, 0.0059823567, 0.0030550486, 0.0010715114, 0.0000000000, 0.0000000000,
    0.0011662298, 0.0028120398, 0.0041195874, 0.0059418486, 0.0095421422, 0.0177941700,
    0.0354721050},
  { 0.0045373550, 0.0038672286, 0.0045760626, 0.0083305753, 0.0084972093, 0.0069630723,
    0.0132399280, 0.0199838480, 0.0264692940, 0.0323835440, 0.0376300620, 0.0430715800,
    0.0478926310, 0.0522457800, 0.0565191060, 0.0609287620, 0.0647395090, 0.0676024980,
    0.0685679850, 0.0683325430, 0.0680913760, 0.0661959880, 0.0601914540, 0.0489260240,
    0.0332863660, 0.0177013260, 0.0067872261, 0.0016522580, 0.0003958713, 0.0003935389,
    0.0000000000},
  { 0.0067372441, 0.0038336965, 0.0013962379, 0.0023528823, 0.0021141319, 0.0005430682,
    0.0005084253, 0.0003048210, 0.0000000000, 0.0000405677, 0.0004394436, 0.0014394717,
    0.0028841940, 0.0047926311, 0.0067491122, 0.0084706897, 0.0101763450, 0.0127504460,
    0.0169259910, 0.0223156120, 0.0278259060, 0.0343945960, 0.0440122970, 0.0577456230,
    0.0747252390, 0.0914706190, 0.1044597200, 0.1122024000, 0.1161866000, 0.1172151600,
    0.1149868300}
};


class vuColourRGBa;
class vuColour31a;

/** Implementation for a colour model with a 'specialized' basis plus alpha channel.
 Derived from vuColour general colour template class. With conversion
 functions from other colour models.
*/
class vuColourSpecial : public vuColour<4>
{
 public:
 	/** default constructor */
  vuColourSpecial() : vuColour<4>() {};
	//! copy constructor
  vuColourSpecial(const vuColourSpecial& inst) : vuColour<4>(inst) {};
  	//! same as copy constructor
  vuColourSpecial(const vuColour<4>& inst) : vuColour<4>(inst) {};
  	/** constructor,
		will copy the ith value of f into the ith component of this */
  vuColourSpecial(const float *f) : vuColour<4>(f) {};
  	/** constructor,
		will set each component to be f */
  vuColourSpecial(const float f) : vuColour<4>(f) {};

  	/** constructor,
		will copy the colour equivalent to inst into this instance */
  vuColourSpecial(const vuColour31a& inst) { from(inst); };

  	/** sets this instance to be rgba */
  void from(const vuColourRGBa& rgba)
    {
      fromColourN((vuColour<4>&)rgba, (float*)CXFRGBtoXYZ);
    };

    	/**  sets this instance to be the equivalent colour of c31a */
  void From(const vuColour31a& c31a)
    {
      fromColourN((vuColour<32>&)c31a, (float*)CXF31toSPEC);
    };

    	/** converts this instance to rgba and stores the result in rgba */
  void to(vuColourRGBa& rgba) const
    {
      toColourN((vuColour<4>&)rgba, (float*)CXFSPECtoRGB);
    };
};

#endif
