/*	Written by Steven Bergner?

	Modifed by Chris Steinbach
	Modified to work in CVS and to add some comments.	
*/

#ifndef _VUCOLOURRGBA_H_
#define  _VUCOLOURRGBA_H_

#include <GL/gl.h>
#include "vuColour.h"

class vuColourRGBa; //forward declaration.
typedef vuColourRGBa* vuColourRGBaPointer;
typedef vuColourRGBaPointer* vuColourRGBaPointerArray;

class vuColour7a;
class vuColour31a;
class vuColourXYZa;

#ifdef USE_OLD_GENERAL_BASIS
static float CXF31toRGB[3][31] = 
{
    {0.0221481, 0.0113145, -0.0126075, -0.0132588, -0.0102731, -0.00152344, -0.000822975,
     -0.0189108, -0.0613606, -0.112387, -0.176256, -0.237649, -0.261535, -0.245734, -0.177019,
     -0.0936128, -0.000861438, 0.0880396, 0.170043, 0.251918, 0.319541, 0.340568, 0.322322, 
     0.285831, 0.24567, 0.181711, 0.111351, 0.0258147, -0.0396012, -0.0279946, 0.0349371 },
    {-0.0084749, -0.0105363, -0.00913255, -0.0125563, -0.0165291, -0.0198257, -0.0169757, 
     -0.0043538, 0.020306, 0.050804, 0.0916869, 0.135146, 0.162128, 0.169987, 0.146177, 0.114236, 
     0.0730239, 0.0322619, -0.00563941, -0.0511607, -0.0866354, -0.103715, -0.10434, -0.0969093, 
     -0.0848042, -0.0654906, -0.0410532, -0.00939417, 0.0141992, 0.00839556, -0.0105299 },
    {-0.00211344, 0.0172473, 0.0470734, 0.0617127, 0.0718481, 0.0716317, 0.0648817, 0.0563307, 
     0.0442519, 0.0288225, 0.00939868, -0.010428, -0.0231866, -0.0280795, -0.0236175, -0.0190545, 
     -0.0124438, -0.00568962, -0.000990886, 0.00185567, -0.000292623, -0.000665409, 9.39556e-05, 
     0.00253106, 0.0027318, 0.005289, 0.00455047, 0.00126459, 0.000157147, 0.00232967, -0.00197713}
};
#else
static float CXF31toRGB[3][31] = {
  {1.2568671e-02, 3.7606721e-02, 1.1294420e-01, 2.2134970e-01, 2.3058628e-01,
   1.4851352e-01, 7.0598400e-03,-1.7386098e-01,-3.4880324e-01,-5.0272966e-01,
   -6.9271268e-01,-9.2852596e-01,-1.0559430e+00,-9.4234654e-01,-6.5263268e-01,
   -2.1608603e-01, 3.5107500e-01, 1.0144334e+00, 1.6979279e+00, 2.2804512e+00,
   2.6256749e+00, 2.6396610e+00, 2.3326014e+00, 1.7910782e+00, 1.2657894e+00,
   8.0774640e-01, 4.7198472e-01, 2.5073652e-01, 1.3439137e-01, 6.5298723e-02,
   3.2686694e-02},
  {-1.2125861e-02,-3.6818572e-02,-1.1301590e-01,-2.3177350e-01,-2.6532541e-01,
   -2.2186313e-01,-1.3344136e-01, 1.6425332e-02, 2.0133044e-01, 3.9357760e-01,
   6.4316570e-01, 9.9046034e-01, 1.3393568e+00, 1.5294281e+00, 1.5770982e+00,
   1.5047624e+00, 1.3325278e+00, 1.0682546e+00, 7.4121938e-01, 4.0011862e-01,
   1.1252816e-01,-7.6934032e-02,-1.5985846e-01,-1.6260684e-01,-1.3268940e-01,
   -9.1436900e-02,-5.5632300e-02,-3.0141000e-02,-1.6374530e-02,-8.0285620e-03,
   -4.0300064e-03},
  {7.1976937e-02, 2.2000198e-01, 6.8472215e-01, 1.4687169e+00, 1.8496649e+00,
   1.8723348e+00, 1.7573790e+00, 1.3452265e+00, 8.3167649e-01, 4.4930774e-01,
   2.2227207e-01, 6.7558410e-02,-5.4137585e-02,-1.1622413e-01,-1.5027145e-01,
   -1.6241357e-01,-1.5844926e-01,-1.4243256e-01,-1.1806964e-01,-9.0193200e-02,
   -6.3665060e-02,-4.2287586e-02,-2.6751952e-02,-1.5985375e-02,-9.2372280e-03,
   -5.1179500e-03,-2.7331300e-03,-1.3833800e-03,-7.1584900e-04,-3.3936000e-04,
   -1.6857329e-04}
};

#endif

#ifdef USE_GENERAL_BASIS
static float CXF7toRGB[3][7] = {
    {3.2942834e-01, 5.8958576e-01,-9.7711590e+00,-1.2614402e+00, 1.6627570e+01,
     8.6353829e+00,-2.0736571e+00},
    {-2.6603804e+00,-1.9611749e+00,7.2353037e+00, 8.5985534e+00, 4.1545139e-01,
     -1.5302089e+00,-2.0588388e-02},
    {4.9275468e+00, 1.2216519e+01,-7.8574767e+00, 3.4105120e+00,-3.2090131e+00,
     5.4337673e-01,-2.2538448e-01}
};
#elif USE_OLD_GENERAL_BASIS
static float CXF7toRGB[3][7] = {
  {  0.977699,  0.631857, -11.661971,  0.719102,  16.026253, 10.004099, -3.704355 },
  { -2.365421, -2.315986,   8.442040,  8.081223,   0.666230, -1.640437, -0.774913 },
  {  3.253197, 19.582254, -19.119486, 17.731441, -24.650227, 16.015902, -3.037327 }
};
#else
//specialized
static float CXF7toRGB[3][7] ={
    {  -1.1594491e-01, 5.4974275e+00, -7.3822550e+00, 5.5211544e+00, 6.5218153e+00, 1.5743127e+00, -9.5834741e-01 },
    {  -1.6780883e+00, -2.8087389e+00, 5.9559563e+00, 1.3316041e+01, -3.6532288e+00, 1.9822677e+00, -2.4715207e+00 },
    {   1.7616780e+00, 3.9115262e+01, -4.0419300e+01, 2.3082971e+01, -1.4414639e+01, 6.6769825e-01, 8.4436487e-01 }
};
#endif

static float CXFXYZtoRGB[3][3] = {
  {  3.5058f, -1.7397f, -0.5440f  },
  { -1.0690f,  1.9778f,  0.0352f  },
  {  0.0563f, -0.1970f,  1.0501f  }
};

/** Implementation for the RGB colour model plus alpha channel.
 Derived from vuColour general colour template class. With conversion
 functions from other colour models.
*/
class vuColourRGBa : public vuColour<4>
{
 public:
 	//! default constructor
  vuColourRGBa() : vuColour<4>() {};
  	/** copy constructor */
  vuColourRGBa(const vuColourRGBa& inst) : vuColour<4>(inst) {};
  	/** same as copy constructor */
  vuColourRGBa(const vuColour<4>& inst) : vuColour<4>(inst) {};
  	/** constructor,
		This will set the ith component of this to be the ith component of f*/
  vuColourRGBa(const float *f) : vuColour<4>(f) {};
  	/** constructor,
		This will set each componet to be f */
  vuColourRGBa(const float f) : vuColour<4>(f) {};
  	/** constructor,
	each component will be set y it';s corresponding value */
  vuColourRGBa(const float r, const float g, const float b, const float a)
    {
      m_Data[0] = r; m_Data[1] = g; m_Data[2] = b; m_Data[3] = a;
    }
    	/** constructor,
	each component will be set by it's corresponing parameter, alpha will be initialized to 1.0 */
  vuColourRGBa(const float r, const float g, const float b)
    {
      m_Data[0] = r; m_Data[1] = g; m_Data[2] = b; m_Data[3] = 1.0f;
    }

    	/** constructor,
		this will initialize this to be the equilavent rgba of the xyza passed in */
  vuColourRGBa(const vuColourXYZa& inst) { from(inst); }
  	/** constructor,
		This will initialise this instance to be the equivalent rgba of the vucolour7a passed in */
  vuColourRGBa(const vuColour7a& inst) { from(inst); }
  	/** constructor,
		This will initialise this instance to be the equivalent rgba of the vucolour 31a passed in */
  vuColourRGBa(const vuColour31a& inst) { from(inst); }

  	/** will copy from xyza into this, converting to the proper format */
  void from(const vuColourXYZa& xyza)
    {
      fromColourN((vuColour<4>&)xyza, (float*)CXFXYZtoRGB);
    };

	/** will copy from vuColour7a into this, converting to the proper format */
  void from(const vuColour7a& c7a)
    {
      fromColourN((vuColour<8>&)c7a, (float*)CXF7toRGB);
    };

  	/** will copy from vuVolour31a into this, converting to the proper format */
  void from(const vuColour31a& c31a)
    {
      fromColourN((vuColour<32>&)c31a, (float*)CXF31toRGB);
    };

  static float* getCXF31toRGB() { return (float*)CXF31toRGB;};

  //!returns the V7 to RGB transformation matrix
  static float* getCXF7toRGB() { return (float*)CXF7toRGB;};

  /** Issue a glColour4f call with the appropriate parameters.
      The colour components will not be clamped! */
  void glColor() {
      glColor4f(m_Data[0], m_Data[1], m_Data[2], m_Data[3]);
  }
  
};

#endif
