#ifndef _VUCOLOUR9A_H_
#define  _VUCOLOUR9A_H_

#include "vuColour.h"

class vuColourRGBa;

static float CXF9toRGB[3][9] =
{
    { -1.4601653e-01,   1.0639283e+00,   5.4538001e-01,  -1.4184008e+00,   3.7348021e+00,
      5.0477205e+00,   2.2590147e+00,  -3.4110859e-02,  -3.8327745e-01 },
    { -1.2479775e+00,   5.1621259e-01,  -1.1707956e+00,   4.0841890e+00,   6.1755619e+00,
      2.7762918e+00,   3.4248372e-01,  -4.5150307e-01,  -3.4306119e-01},
    { 9.1598366e-01,   9.8810768e+00,   3.3319956e+00,  -2.6782421e+00,   7.1566989e-01,
      -8.2538437e-01,   5.2107713e-01,  -1.2175700e+00,  -1.4383627e-02
    }
};

static float CXF31to9[9][31] = {
    { 1.5010492e+00,   1.6871730e+00,   1.3687703e+00,   7.7331782e-01,   2.1807997e-01,
      -2.5216521e-01,  -4.8409348e-01,  -4.4724444e-01,  -1.3134729e-01,   1.4531885e-01,
      2.0626154e-01,   4.3927901e-02,  -3.5710054e-01,  -6.2689505e-01,  -4.6448144e-01,
      -2.1500322e-01,   6.6068518e-02,   2.2320319e-01,   1.0804027e-01,   2.1518206e-02,
      -2.4057840e-01,  -2.5054929e-01,  -9.0174747e-02,   1.7152564e-01,   1.4197545e-01,
      2.3775307e-01,   1.7729939e-02,  -3.2821206e-01,  -2.7081198e-01,   1.6099215e-01,
      3.7336168e-02},
    {-5.4919524e-01,  -5.4594840e-01,  -1.3981436e-01,   3.2436897e-01,   1.6175578e+00,
     2.4065387e+00,   2.1515998e+00,   9.5121676e-01,  -8.2245353e-01,  -2.1550724e+00,
     -2.1518105e+00,  -1.0646296e+00,   8.2726957e-01,   2.2233131e+00,   1.6510663e+00,
     5.7222304e-01,  -5.4545193e-01,  -1.2154574e+00,  -1.0658067e+00,  -7.5220005e-01,
     3.6719788e-01,   7.5051365e-01,   3.8276599e-01,  -4.5640306e-01,  -3.6190735e-01,
     -7.3358291e-01,  -1.8232516e-01,   7.7541027e-01,   5.9287569e-01,  -6.4106245e-01,
     4.8443610e-02},
    {-3.4905770e-01,  -1.5860787e-01,   1.0565880e-01,   5.4778197e-01,  -3.1735915e-01,
     -7.9767182e-01,  -3.5951052e-01,   8.7841908e-01,   2.3651400e+00,   3.2904712e+00,
     2.5227706e+00,   7.9762700e-01,  -1.3517988e+00,  -2.8689844e+00,  -2.0387526e+00,
     -7.3874093e-01,   6.2992470e-01,   1.4138885e+00,   1.1148373e+00,   7.4540391e-01,
     -6.0977743e-01,  -1.0497006e+00,  -5.4923986e-01,   5.7899563e-01,   4.6200736e-01,
     9.2308602e-01,   1.7931733e-01,  -1.0850559e+00,  -8.5713263e-01,   7.9457253e-01,
     -1.6462608e-01},
    {4.9704352e-01,   1.9935986e-01,  -3.6538734e-01,  -1.1112966e+00,  -5.2332505e-01,
     3.4276198e-03,   5.0460022e-02,  -2.4516036e-01,  -4.1660563e-01,  -5.1987566e-01,
     5.0728863e-01,   1.6503608e+00,   2.4706817e+00,   2.8554987e+00,   1.6693683e+00,
     4.4089330e-01,  -8.5282206e-01,  -1.5288993e+00,  -1.0056661e+00,  -5.5394063e-01,
     6.1227504e-01,   9.2288640e-01,   4.1005847e-01,  -6.7557835e-01,  -5.8866438e-01,
     -9.6713239e-01,  -1.8154152e-01,   1.0763024e+00,   8.6722938e-01,  -7.9398715e-01,
     -6.6199811e-03},
    {-4.2506220e-01,  -2.2789148e-01,   2.2249201e-01,   8.3245731e-01,   2.8221904e-01,
     -2.2716922e-01,  -3.1950462e-01,  -1.0290377e-01,   5.9624772e-02,   3.2043098e-01,
     -1.6427942e-01,  -5.3295940e-01,  -4.5699716e-01,  -1.6929304e-01,   8.1602063e-01,
     1.5301528e+00,   2.1528594e+00,   2.2219957e+00,   1.2296648e+00,   3.7234754e-01,
     -8.0777117e-01,  -1.0693223e+00,  -5.1961719e-01,   5.3020857e-01,   4.6816429e-01,
     7.4519895e-01,  -3.3211479e-02,  -1.2033092e+00,  -1.0186240e+00,   5.1196332e-01,
     -6.5913131e-02},
    {2.6192195e-01,   2.1208399e-01,  -1.2863588e-01,  -6.6035302e-01,  -2.4418658e-01,
     1.3157824e-01,   1.8995612e-01,   2.9053809e-02,  -5.5878879e-02,  -2.0496383e-01,
     2.1393185e-01,   3.7520160e-01,   1.1640578e-03,  -3.2672022e-01,  -6.8747635e-01,
     -5.3658907e-01,  -3.4174084e-01,   1.5161648e-01,   1.3148438e+00,   1.8013867e+00,
     2.1796383e+00,   1.5415905e+00,   3.6584010e-01,  -1.0040271e+00,  -1.0798039e+00,
     -1.2327156e+00,  -3.2659140e-01,   9.1301919e-01,   8.5050485e-01,  -5.4781412e-01,
     -1.3438061e-01},
    {-4.9605296e-02,  -2.5096247e-01,   5.5609486e-03,   6.1216718e-01,   1.3494532e-01,
     -1.9388264e-01,  -1.3719668e-01,   9.1654583e-02,   1.1783621e-01,   1.2830304e-01,
     -5.2937964e-01,  -6.5544824e-01,   3.5168342e-02,   4.6438950e-01,   7.4979179e-01,
     2.7752462e-01,  -1.5259612e-01,  -6.0780017e-01,  -1.3140204e+00,  -6.2102573e-01,
     -2.6462596e-01,   6.8972706e-01,   1.4273453e+00,   2.2646068e+00,   1.8951178e+00,
     1.5999623e+00,  -1.2133352e-01,  -2.1011259e+00,  -1.9148408e+00,   4.7956763e-01,
     2.5414822e-01},
    {4.3639454e-02,   2.2586993e-01,  -1.4267185e-02,  -5.8405818e-01,  -1.8347767e-01,
     7.2475284e-02,  -7.4161072e-03,  -1.9909688e-01,  -1.4943236e-01,  -9.1546391e-02,
     5.2937378e-01,   5.7280436e-01,  -2.0110741e-01,  -6.0842631e-01,  -8.2848975e-01,
     -3.0386245e-01,   1.2658237e-01,   4.4460195e-01,   8.2322597e-01,  -1.3418964e-01,
     -1.8738156e-01,  -3.9888645e-01,  -2.4331493e-01,  -4.4266048e-01,   1.0723166e-01,
     2.3184386e-01,   1.6527983e+00,   3.2409383e+00,   2.4625994e+00,  -6.6853477e-01,
     -9.0189174e-01},
     {-5.6678868e-02,  -7.1670285e-02,   1.9966037e-02,   2.0342290e-01,   1.8721702e-02,
      -1.1262895e-01,  -9.1376741e-02,   7.4160010e-03,   4.3640467e-02,   8.2075743e-02,
      -1.1411154e-01,  -1.7237197e-01,   3.2190836e-03,   4.8062635e-02,   1.3250239e-01,
      -1.5539208e-03,  -7.3216603e-02,  -1.1122242e-01,  -2.1120949e-01,   9.7723250e-02,
      -5.0431235e-02,  -1.1575637e-01,  -1.6657360e-01,   2.8795026e-02,  -4.2225531e-02,
      1.9046923e-01,  -1.2757553e-02,  -2.9405319e-01,   2.8192564e-01,   1.6895421e+00,
      1.9586607e+00}
};

static float CXF9to31[31][9] = {
    {1.9396606e-01,   8.3417820e-03,   0.0000000e+00,   4.2893191e-02,   0.0000000e+00,
     2.2948747e-02,   1.1074235e-02,   3.8208623e-03,   0.0000000e+00},
    {2.2034290e-01,   2.6668097e-02,   1.0509422e-02,   4.0558125e-02,   8.9335660e-03,
     1.9318946e-02,   1.5967869e-03,   1.0469447e-02,   5.0374806e-04},
    {1.8589831e-01,   5.4395844e-02,   2.8376273e-02,   2.3860946e-02,   1.9383804e-02,
     1.0857007e-02,   4.3117474e-04,   9.0754444e-03,   6.9070435e-03},
    {1.1322126e-01,   8.0954451e-02,   4.9768817e-02,   0.0000000e+00,   2.8944133e-02,
     0.0000000e+00,   6.4255140e-03,   0.0000000e+00,   1.8831134e-02},
    {8.3855436e-02,   1.2208412e-01,   6.8211468e-02,   0.0000000e+00,   2.0769617e-02,
     9.1080458e-03,   9.7241918e-04,   1.0295430e-02,   7.6872718e-03},
    {5.2721842e-02,   1.4693809e-01,   8.6192988e-02,   5.4103249e-03,   9.8472382e-03,
     1.8900239e-02,   0.0000000e+00,   1.4936065e-02,   0.0000000e+00},
    {2.1487415e-02,   1.4331367e-01,   1.0162880e-01,   1.3119993e-02,   3.1307034e-03,
     2.1555192e-02,   4.3476982e-03,   1.0293814e-02,   2.0382115e-03},
    {0.0000000e+00,   1.1690413e-01,   1.1726562e-01,   2.7417811e-02,   1.0117269e-03,
     1.6777940e-02,   1.0145609e-02,   2.6418220e-03,   8.4465302e-03},
    {3.9930563e-03,   7.3772646e-02,   1.2951995e-01,   5.5445031e-02,   0.0000000e+00,
     9.9187727e-03,   1.2937079e-02,   2.1220967e-04,   9.6660025e-03},
    {8.2444658e-03,   3.1777269e-02,   1.2494476e-01,   7.5089481e-02,   7.3136282e-03,
     0.0000000e+00,   1.1879379e-02,   0.0000000e+00,   1.1594168e-02},
    {2.4468666e-02,   6.1464786e-03,   1.0298420e-01,   1.0300836e-01,   1.0596667e-02,
     1.1653563e-03,   1.4110863e-03,   1.2613170e-02,   0.0000000e+00},
    {3.0726613e-02,   0.0000000e+00,   6.9737353e-02,   1.1908655e-01,   2.0468467e-02,
     4.1030677e-03,   0.0000000e+00,   1.4298336e-02,   0.0000000e+00},
    {1.5331154e-02,   1.4924544e-02,   3.4362412e-02,   1.1811841e-01,   4.0865401e-02,
     2.1844167e-03,   1.0551318e-02,   8.9938709e-04,   1.7480965e-02},
    {5.9537656e-03,   3.0221627e-02,   7.0212805e-03,   1.1197527e-01,   6.7613359e-02,
     0.0000000e+00,   1.7832125e-02,   0.0000000e+00,   2.0623424e-02},
    {0.0000000e+00,   2.5798766e-02,   0.0000000e+00,   8.4451206e-02,   9.7220993e-02,
     1.4550873e-03,   2.0515088e-02,   1.9206477e-03,   2.2668703e-02},
    {0.0000000e+00,   1.6226557e-02,   0.0000000e+00,   5.6874652e-02,   1.1950831e-01,
     1.2360582e-02,   1.2296924e-02,   1.9281596e-02,   7.9122112e-03},
    {2.0272112e-03,   6.7605713e-03,   9.5102828e-04,   2.5022844e-02,   1.3346419e-01,
     2.5802389e-02,   4.1380300e-03,   3.1578839e-02,   0.0000000e+00},
    {4.1248381e-03,   4.9832947e-04,   2.0107501e-03,   2.8664971e-03,   1.3077361e-01,
     5.1281261e-02,   0.0000000e+00,   3.5547977e-02,   2.5111682e-04},
    {2.9309793e-03,   4.2947611e-04,   3.9950131e-03,   0.0000000e+00,   1.0043238e-01,
     1.0132279e-01,   3.1669294e-03,   3.3192302e-02,   3.7469111e-03},
    {8.1998963e-04,   0.0000000e+00,   8.4221233e-03,   0.0000000e+00,   5.7899232e-02,
     1.4701101e-01,   3.7303443e-02,   0.0000000e+00,   3.9643212e-02},
    {0.0000000e+00,   1.0719294e-02,   4.7612682e-03,   1.0541569e-02,   1.8987564e-02,
     1.6992594e-01,   7.7319840e-02,   8.6539817e-03,   2.8835196e-02},
    {3.3880422e-03,   1.2932282e-02,   3.5460568e-03,   1.6742243e-02,   0.0000000e+00,
     1.4993502e-01,   1.2028851e-01,   2.8091781e-02,   1.5130285e-02},
    {4.8691767e-03,   8.7213745e-03,   4.8561110e-03,   1.4588689e-02,   4.7495528e-03,
     9.4609413e-02,   1.4062377e-01,   6.1926804e-02,   0.0000000e+00},
    {3.5854057e-03,   0.0000000e+00,   9.1236065e-03,   5.3530171e-03,   2.0843435e-02,
     3.5146240e-02,   1.4735886e-01,   7.9312192e-02,   9.2372490e-03},
    {3.0366319e-03,   2.5365510e-03,   7.3158884e-03,   5.2479006e-03,   2.0969866e-02,
     1.7079676e-02,   1.3725082e-01,   1.0011314e-01,   8.0113866e-03},
    {4.3080855e-03,   0.0000000e+00,   9.2886920e-03,   0.0000000e+00,   2.5639039e-02,
     0.0000000e+00,   1.1269915e-01,   9.9043526e-02,   3.9339847e-02},
    {2.9784431e-03,   1.0256419e-02,   5.8717757e-03,   4.4835785e-03,   1.6825047e-02,
     0.0000000e+00,   6.6543482e-02,   1.2514744e-01,   4.2660585e-02},
    {0.0000000e+00,   2.4543913e-02,   0.0000000e+00,   1.4142951e-02,   1.3461108e-03,
     1.0583383e-02,   1.9116844e-02,   1.5236244e-01,   4.2538057e-02},
    {0.0000000e+00,   2.0504517e-02,   9.3633670e-04,   1.2993784e-02,   0.0000000e+00,
     1.3925459e-02,   0.0000000e+00,   1.1596599e-01,   1.1011712e-01},
    {9.4208104e-04,   0.0000000e+00,   8.3979908e-03,   0.0000000e+00,   1.2462368e-02,
     8.8793653e-03,   1.1773887e-02,   1.8305359e-02,   2.4203640e-01},
    {6.7781784e-03,   3.6292015e-03,   0.0000000e+00,   1.0707579e-02,   0.0000000e+00,
     2.3844659e-02,   0.0000000e+00,   0.0000000e+00,   2.8409322e-01},
};


/** Implementation for the seven component colour model plus alpha channel.
 Derived from vuColour general colour template class. With conversion
 functions from other colour models.
*/
class vuColour9a : public vuColour<10>
{
 public:
  /** default constructor */
  vuColour9a() : vuColour<10>() {};
  /** copy constructor */
  vuColour9a(const vuColour9a& inst) : vuColour<10>(inst) {};
  /** constructor,
  	basiclly a copy constructor */
  vuColour9a(const vuColour<10>& inst) : vuColour<10>(inst) {};

  /** cunstruct from an array of floats.  
      The alpha value is taken from the N+1st position. */
  vuColour9a(const float *f) : vuColour<10>(f) {};
  /** Sets all components (including the alpha value) to f. */
  vuColour9a(const float f) : vuColour<10>(f) {};

  	/** this will convert the vuColour9a to RGBA and store that value in rgba */
  void to(vuColourRGBa& rgba)
    {
	toColourN((vuColour<4>&)rgba, (float*)CXF9toRGB);
    }

    /** This will convert from c31a to vucolour9a and store the result in this instance */
  void from(const vuColour31a& c31a)
    {
	fromColourN((vuColour<32>&)c31a, (float*)CXF31to9);
    }

    	/** this will convert the value stored in this instance to vucolour31a and store the result in c31a */
  void to(vuColour31a& c31a)
    {
	toColourN((vuColour<32>&)c31a, (float*)CXF9to31);
    }

};

#endif
