#ifndef _VUCOLOUR7A_H_
#define  _VUCOLOUR7A_H_

#include "vuColour.h"

class vuColourRGBa;
class vuColourXYZa;
class vuColour31a;

#ifdef USE_GENERAL_BASIS
/**-- general basis -- 
 * Transform vuColour31a (full spectrum) to vuColour7a. */
static float CXF31to7[7][31] = {
    {1.2913105e-01, 1.5253018e-01, 1.4154656e-01, 1.0574002e-01, 1.0458454e-01,
     9.4486027e-02, 7.0508484e-02, 4.0804347e-02, 1.8667997e-02, 0.0000000e+00,
     0.0000000e+00, 7.4051800e-03, 1.4098413e-02, 2.1824785e-02, 1.6262405e-02,
     8.7110586e-03, 2.7723342e-03, 0.0000000e+00, 1.5368542e-04, 3.2073358e-03,
     1.1216282e-02, 1.5273987e-02, 1.1160928e-02, 2.8222770e-03, 1.9850616e-03,
     0.0000000e+00, 1.5793829e-03, 4.9089495e-03, 5.2035736e-03, 2.0967212e-03,
     1.1318433e-02},
    {0.0000000e+00, 1.1210836e-02, 2.9103518e-02, 4.9446387e-02, 7.2145155e-02,
     9.2668442e-02, 1.0689547e-01, 1.1834110e-01, 1.2545983e-01, 1.1707636e-01,
     9.6650550e-02, 6.6356110e-02, 3.3680392e-02, 8.6645027e-03, 2.4039133e-04,
     0.0000000e+00, 6.8382299e-04, 2.7245372e-03, 8.5134830e-03, 1.2941055e-02,
     1.0917532e-02, 6.6887750e-03, 3.0277282e-03, 1.1799357e-03, 0.0000000e+00,
     1.7026254e-03, 4.4202780e-03, 6.5575707e-03, 7.0525279e-03, 5.6510949e-03,
     0.0000000e+00},
    {3.5687689e-02, 3.2844018e-02, 1.9165534e-02, 6.9974822e-04, 0.0000000e+00,
     5.3156086e-03, 1.4738386e-02, 3.1642499e-02, 6.0969750e-02, 8.1396663e-02,
     1.0617772e-01, 1.2025340e-01, 1.2035505e-01, 1.1485992e-01, 8.9407736e-02,
     6.1651245e-02, 2.9534060e-02, 6.2348656e-03, 0.0000000e+00, 0.0000000e+00,
     7.4462486e-03, 1.3085454e-02, 1.1832966e-02, 5.7940379e-03, 4.4549819e-03,
     0.0000000e+00, 0.0000000e+00, 3.9040890e-03, 5.4701335e-03, 3.6058299e-03,
     1.3472363e-02},
    {0.0000000e+00, 7.5747528e-03, 1.7657598e-02, 2.6368651e-02, 2.9098178e-02,
     2.6181081e-02, 1.9298409e-02, 1.0261038e-02, 0.0000000e+00, 0.0000000e+00,
     8.8516584e-03, 3.0552863e-02, 6.5518650e-02, 1.0098675e-01, 1.1864524e-01,
     1.2513728e-01, 1.2276816e-01, 1.1020728e-01, 8.1705897e-02, 4.3036150e-02,
     1.5579734e-02, 0.0000000e+00, 0.0000000e+00, 6.3937226e-03, 7.4555850e-03,
     8.9827928e-03, 7.5671127e-03, 4.1899874e-03, 2.7200079e-03, 3.2614161e-03,
     0.0000000e+00},
    {2.9580810e-02, 2.9041592e-02, 1.8508875e-02, 3.2348948e-03, 0.0000000e+00,
     2.5304451e-04, 2.0314026e-03, 5.2697850e-03, 1.2744323e-02, 1.6250582e-02,
     2.1388691e-02, 1.9905568e-02, 7.5816420e-03, 0.0000000e+00, 9.1557586e-03,
     3.0163042e-02, 5.1817988e-02, 7.7726520e-02, 1.1438463e-01, 1.4052652e-01,
     1.4301567e-01, 1.1660470e-01, 7.0542092e-02, 2.6421756e-02, 1.1135345e-02,
     1.0879652e-03, 0.0000000e+00, 4.4976884e-03, 8.7098274e-03, 1.0701598e-02,
     1.7717698e-02},
    {4.7625752e-03, 1.1060937e-03, 0.0000000e+00, 2.3211012e-04, 2.9652922e-03,
     5.1528901e-03, 5.1229311e-03, 3.5528531e-03, 1.9767991e-03, 0.0000000e+00,
     0.0000000e+00, 1.7767586e-03, 4.9094258e-03, 1.0881941e-02, 1.0898793e-02,
     1.0066623e-02, 6.8033918e-03, 2.3833828e-03, 0.0000000e+00, 3.8204624e-03,
     3.7329491e-02, 8.0716041e-02, 1.1756954e-01, 1.3554434e-01, 1.4203171e-01,
     1.2609936e-01, 1.1051269e-01, 9.4640602e-02, 6.2321066e-02, 1.6822838e-02,
     0.0000000e+00},
    {0.0000000e+00, 4.8892266e-03, 8.6037442e-03, 1.1043274e-02, 1.0285065e-02,
     7.7775327e-03, 5.4062071e-03, 3.4881667e-03, 7.6726776e-04, 5.5173043e-04,
     0.0000000e+00, 9.7424710e-04, 4.7614830e-03, 4.9212197e-03, 4.0825669e-03,
     7.0637915e-04, 0.0000000e+00, 6.5374668e-04, 3.3329319e-05, 3.3255854e-03,
     0.0000000e+00, 2.2903435e-03, 1.4587071e-02, 3.4649168e-02, 4.9132868e-02,
     7.4371904e-02, 9.8147846e-02, 1.2017414e-01, 1.4859153e-01, 1.8238979e-01,
     2.0339457e-01
    }
};
#elif USE_OLD_GENERAL_BASIS
/**-- general basis -- 
 * Transform vuColour31a (full spectrum) to vuColour7a. */
static float CXF31to7[7][31] = {
  {
    1.2002231e-01, 1.4073467e-01, 1.4096815e-01, 1.1263114e-01,
    1.0626643e-01, 9.2993271e-02, 6.9433109e-02, 4.4381567e-02,
    2.3690000e-02, 6.2149451e-03, 0.0000000e+00, 3.6648484e-03,
    7.9302968e-03, 1.4693569e-02, 1.5906165e-02, 1.4484020e-02,
    1.0509659e-02, 8.6627655e-03, 9.2364097e-03, 4.2304034e-03,
    0.0000000e+00, 0.0000000e+00, 3.9506079e-04, 6.3332447e-04,
    3.0567183e-03, 6.5464161e-03, 9.8682043e-03, 1.2157955e-02, 
    1.2582588e-02, 8.1060029e-03, 0.0000000e+00
  },{
    0.0000000e+00, 6.5185226e-03, 1.9663932e-02, 3.4135592e-02,
    5.9434493e-02, 8.2437346e-02, 9.6845746e-02, 1.0501623e-01,
    1.1065374e-01, 1.0197605e-01, 8.6785629e-02, 5.9685237e-02,
    3.1977043e-02, 1.3914838e-02, 3.8057357e-03, 1.7769007e-04,
    3.2677888e-04, 0.0000000e+00, 1.6175729e-03, 1.3238266e-02,
    2.5796069e-02, 3.0293402e-02, 2.8430804e-02, 2.2949995e-02,
    1.6393529e-02, 8.2613872e-03, 2.7956703e-03, 0.0000000e+00,
    0.0000000e+00, 7.7654633e-03, 2.9103232e-02
  },{
    3.3822199e-02, 2.7107744e-02, 1.1769212e-02, 0.0000000e+00,
    5.2751063e-03, 1.5562897e-02, 2.4683757e-02, 3.4941433e-02,
    5.2636229e-02, 6.7514950e-02, 8.9435649e-02, 1.0655434e-01,
    1.0898780e-01, 1.0385029e-01, 8.3823686e-02, 6.6251940e-02,
    4.5513451e-02, 2.5497467e-02, 1.1062665e-02, 0.0000000e+00,
    0.0000000e+00, 6.6739476e-04, 1.8066428e-03, 0.0000000e+00,
    3.8082520e-03, 4.9702696e-03, 1.2481071e-02, 2.5221304e-02,
    2.7138986e-02, 9.6152707e-03, 0.0000000e+00
  },{
    0.0000000e+00, 8.7633041e-03, 2.3209989e-02, 2.6204612e-02,
    2.1875648e-02, 1.2010727e-02, 3.7960413e-03, 7.1264066e-04,
    0.0000000e+00, 5.6856235e-03, 1.8981450e-02, 4.3147074e-02,
    7.1665066e-02, 9.7505613e-02, 1.0908012e-01, 1.1256399e-01,
    1.0692711e-01, 9.9948109e-02, 9.0319237e-02, 6.2443765e-02,
    3.5978660e-02, 1.7414736e-02, 6.4102351e-03, 1.8968710e-03,
    0.0000000e+00, 8.3020907e-05, 2.7017146e-04, 0.0000000e+00,
    3.0983801e-03, 8.6533473e-03, 1.1354455e-02
  },{
    9.0700972e-03, 5.7734268e-03, 0.0000000e+00, 0.0000000e+00,
    4.2045100e-03, 1.0315085e-02, 1.4566234e-02, 1.5615907e-02,
    1.3371402e-02, 8.2711135e-03, 3.5818712e-03, 0.0000000e+00,
    2.6421273e-03, 1.2688784e-02, 2.6361042e-02, 4.2134036e-02,
    5.6258719e-02, 6.8834775e-02, 8.0616887e-02, 8.8620047e-02,
    9.7238975e-02, 9.5886654e-02, 8.6737515e-02, 7.4278309e-02,
    6.3171764e-02, 4.6006416e-02, 3.0030269e-02, 1.2651911e-02,
    0.0000000e+00, 4.5688094e-03, 2.6503312e-02
  },{
    2.6018824e-02, 2.0772074e-02, 7.7346765e-03, 0.0000000e+00,
    1.6594244e-03, 6.4943627e-03, 9.0531780e-03, 9.6299359e-03,
    1.0303552e-02, 9.9028742e-03, 1.1838819e-02, 1.0453470e-02,
    4.6030257e-03, 0.0000000e+00, 0.0000000e+00, 6.9064878e-03,
    1.5262097e-02, 2.4237652e-02, 3.6236839e-02, 5.1408105e-02,
    7.2563657e-02, 8.5594325e-02, 9.1085725e-02, 8.8567301e-02,
    9.0759965e-02, 8.4086898e-02, 7.9025435e-02, 7.2232715e-02,
    5.2420387e-02, 2.1148194e-02, 0.0000000e+00
  },{
    0.0000000e+00, 9.6785045e-03, 2.4089121e-02, 2.7182328e-02,
    2.3954977e-02, 1.4941675e-02, 6.0206013e-03, 1.6032588e-03,
    0.0000000e+00, 4.1984497e-03, 1.1135957e-02, 1.9469615e-02,
    2.2616046e-02, 1.9303135e-02, 1.4576435e-02, 9.8628959e-03,
    5.5518575e-03, 2.9655059e-03, 1.7280836e-03, 0.0000000e+00,
    2.1840396e-03, 1.3506427e-02, 3.1153770e-02, 4.8780678e-02,
    6.9310666e-02, 9.0208187e-02, 1.0955650e-01, 1.2723541e-01,
    1.2904578e-01, 1.0168743e-01, 5.8452669e-02
  }
};

#else

/*-- specialized basis -- */
/** Transform vuColour31a (full spectrum) to vuColour7a. */
static float CXF31to7[7][31] = {
    {
	1.3618155e-01, 1.4370534e-01, 1.4168173e-01, 1.3672959e-01, 1.1622784e-01, 8.7572932e-02,
	5.9309406e-02, 3.6051377e-02, 1.8152161e-02, 6.6294937e-03, 1.2406933e-03, 0.0000000e+00,
	5.5478080e-04, 2.7208645e-03, 6.6927598e-03, 1.1451176e-02, 1.5636109e-02, 1.5714090e-02,
	1.0988279e-02, 7.8135314e-03, 6.7908767e-03, 5.5921137e-03, 3.1061407e-03, 5.9422488e-04,
	0.0000000e+00, 2.1996150e-03, 6.3818472e-03, 9.7188720e-03, 8.1329166e-03, 2.4296940e-03,
	0.0000000e+00
    },{
 	0.0000000e+00, 1.9853572e-02, 1.8298461e-02, 1.1851274e-02, 2.9164839e-02, 5.6976392e-02,
	8.5441708e-02, 1.0295338e-01, 1.1038465e-01, 1.0849193e-01, 9.7748082e-02, 8.2861109e-02,
	6.7234120e-02, 5.1177752e-02, 3.4057656e-02, 1.7750143e-02, 4.1669202e-03, 0.0000000e+00,
	5.6515037e-03, 8.4589159e-03, 7.4395464e-03, 7.1020408e-03, 9.4499304e-03, 1.1375657e-02,
	1.0164508e-02, 5.4806422e-03, 0.0000000e+00, 0.0000000e+00, 8.4553284e-03, 1.4677622e-02,
	1.3332325e-02
    },{
	1.4608250e-02, 1.7897444e-02, 1.0222349e-02, 0.0000000e+00, 4.6979604e-03, 1.7616064e-02,
	5.0030323e-02, 7.4454635e-02, 8.9643483e-02, 9.5390845e-02, 9.1171025e-02, 8.1655965e-02,
	7.0671676e-02, 5.9332103e-02, 4.7316468e-02, 3.5860095e-02, 2.5439803e-02, 2.1563180e-02,
	2.4315953e-02, 2.4137502e-02, 2.0450309e-02, 1.6979663e-02, 1.5355884e-02, 1.1287936e-02,
	5.1599727e-03, 0.0000000e+00, 9.5681213e-04, 1.5995079e-02, 3.4781019e-02, 2.3008202e-02,
	0.0000000e+00
    },{
	1.5662859e-02, 0.0000000e+00, 1.7886178e-02, 4.2089009e-02, 3.3931326e-02, 1.1042613e-02,
	2.1641198e-03, 0.0000000e+00, 1.6926754e-03, 7.6931316e-03, 1.7630668e-02, 2.9265722e-02,
	3.9565703e-02, 4.9680173e-02, 6.1130838e-02, 7.3019227e-02, 8.2936168e-02, 8.4321952e-02,
	7.4162973e-02, 6.5846467e-02, 6.2032348e-02, 5.7607426e-02, 4.7667511e-02, 3.0610834e-02,
	1.2180689e-02, 0.0000000e+00, 0.0000000e+00, 1.7524028e-02, 3.7806551e-02, 2.4848808e-02,
	0.0000000e+00,
    },{
	1.0501668e-02, 0.0000000e+00, 9.1153083e-03, 2.2549151e-02, 1.7485475e-02, 4.1934894e-03,
	0.0000000e+00, 0.0000000e+00, 2.3980977e-03, 7.5363528e-03, 1.5452670e-02, 2.4926536e-02,
	3.3806189e-02, 4.2620486e-02, 5.2320288e-02, 6.2508750e-02, 7.2116351e-02, 7.6326759e-02,
	7.2148726e-02, 6.9517238e-02, 7.1131034e-02, 7.2636422e-02, 6.8459681e-02, 5.7460345e-02,
	4.1169389e-02, 2.3410504e-02, 7.8870986e-03, 0.0000000e+00, 6.8323910e-03, 2.4488469e-02,
	3.1001130e-02
    },{
	9.9279499e-03, 2.2220714e-02, 1.2324782e-02, 0.0000000e+00, 4.5589222e-03, 1.6907276e-02,
	1.0825149e-02, 4.9179754e-03, 1.3388643e-03, 0.0000000e+00, 1.3746338e-03, 4.8935286e-03,
	9.3269409e-03, 1.2212991e-02, 1.1491088e-02, 7.4167365e-03, 3.0376778e-03, 4.9298639e-03,
	1.8635161e-02, 3.1657369e-02, 3.9381012e-02, 4.6315190e-02, 6.0222530e-02, 9.0497222e-02,
	1.2603100e-01, 1.4845063e-01, 1.3961063e-01, 7.7619138e-02, 0.0000000e+00, 1.5459086e-02,
	6.8415932e-02
    },{
	9.0072791e-03, 0.0000000e+00, 8.9911708e-03, 2.0269104e-02, 1.4440107e-02, 1.1588738e-03,
	0.0000000e+00, 1.8538418e-03, 4.8514858e-03, 8.7265864e-03, 1.2378906e-02, 1.5046852e-02,
	1.6484397e-02, 1.7829940e-02, 1.9633168e-02, 2.1194292e-02, 2.0404693e-02, 1.7384328e-02,
	1.3956074e-02, 1.0654694e-02, 5.8403335e-03, 7.3060091e-04, 0.0000000e+00, 3.5592431e-03,
	1.8382633e-02, 4.9331475e-02, 9.8466660e-02, 1.6220047e-01, 1.9553738e-01, 1.4024804e-01,
	9.1437370e-02
    }
};
#endif

/** Implementation for the seven component colour model plus alpha channel.
 Derived from vuColour general colour template class. With conversion
 functions from other colour models.
*/
class vuColour7a : public vuColour<8>
{
 public:
  /** default constructor */
  vuColour7a() : vuColour<8>() {};
  /** copy constructor */
  vuColour7a(const vuColour7a& inst) : vuColour<8>(inst) {};
  /** copy constructor */
  vuColour7a(const vuColour<8>& inst) : vuColour<8>(inst) {};

  /** cunstruct from an array of floats.  
      The alpha value is taken from the N+1st position. */
  vuColour7a(const float *f) : vuColour<8>(f) {};
  /** Sets all components (including the alpha value) to f. */
  vuColour7a(const float f) : vuColour<8>(f) {};

  /** construct from a full spectrum */
  vuColour7a(const vuColour31a& c31a) { from(c31a); };

  /** takes the value stored in c31a, converts it to the equivalent value in 7a format,
  	and saves the converted value in this object */
  void from(const vuColour31a& c31a)
    {
      fromColourN((vuColour<32>&)c31a, (float*)CXF31to7);
    }

  //!returns the V31 to V7 transformation matrix
  static float* getCXF31to7() { return (float*) CXF31to7;};

};

#endif
