#ifndef _VUCOLOUR31A_H_
#define  _VUCOLOUR31A_H_

#include <math.h>
#include "vuColour.h"

/** pseudoinverse of CXF31toRGB */
static float CXFRGBto31[31][3] = {
  { 3114.62, -795.361, 1344.83 },
  { 1771, -895.781, 2188.5 },
  { -316.973, 37.1734, -337.209 },
  { -209.781, 121.115, 24.6211 },
  { -2248.86, 6.00256, -576.98 },
  { 536.207, -20.1586, 335.44 },
  { -38.9062, -26.7664, 10.4036 },
  { 1191.22, -503.787, 762.416 },
  { -1847.7, 908.315, -2048.51 },
  { 526.844, -111.009, 1208.23 },
  { 1026.86, -105.122, 299.374 },
  { -39.5918, 73.5609, -65.1626 },
  { -362.516, -193.222, -240.738 },
};

class vuColourRGBa;

/** Implementation for the 'full; spectral colour model.
    It has 31 components plus alpha channel.  Derived from
    vuColour. With conversion functions from other colour models.
*/
class vuColour31a : public vuColour<32>
{
 public:
  /** default constructor */
  vuColour31a() : vuColour<32>() {};
  /** copy constructor */
  vuColour31a(const vuColour31a& inst) : vuColour<32>(inst) {};
  /** copy constructor */
  vuColour31a(const vuColour<32>& inst) : vuColour<32>(inst) {};
  /** cunstruct from an array of floats.  
      The alpha value is taken from the N+1st position. */
  vuColour31a(const float *f) : vuColour<32>(f) {};
  /** cunstruct from an array of doubles.  
      The alpha value is taken from the N+1st position. */
  vuColour31a(const double *f) : vuColour<32>(f) {};
  /** Sets all components (including the alpha value) to f. */
  vuColour31a(const float f) : vuColour<32>(f) {};

  /** construct a spectrum from RGBa colour.  Calls from() */
  vuColour31a(const vuColourRGBa& rgba) { from(rgba); };

  /** sets up a spectrum from an vuColourRGBa.  This is done using the
      pseudoinverse of the 31a -> RGBa transform. The resulting spectrum
      is one of many possible spectra.
  */
  void from(const vuColourRGBa& rgba)
    {
      fromColourN((vuColour<4>&)(rgba), (float*)CXFRGBto31);
    };

  /** generates the spectrum for a planckian black body radiator of temerature T (Kelvin) */
  vuColour31a& planckian(const float T)
      {
	  m_Data[0] = float(537.8239999*exp(-10277.14286/T));
	  m_Data[1] = float(475.3580484*exp(-9399.825790/T));
	  m_Data[2] = float(421.3991769*exp(-8564.285720/T));
	  m_Data[3] = float(374.6259499*exp(-7767.607980/T));
	  m_Data[4] = float(333.9463897*exp(-7007.142860/T));
	  m_Data[5] = float(298.4541116*exp(-6280.476190/T));
	  m_Data[6] = float(267.3935805*exp(-5585.403730/T));
	  m_Data[7] = float(240.1324465*exp(-4919.908820/T));
	  m_Data[8] = float(216.1394033*exp(-4282.142860/T));
	  m_Data[9] = float(194.9663831*exp(-3670.408170/T));
	  m_Data[10] = float(176.2341683*exp(-3083.142860/T));
	  m_Data[11] = float(159.6207160*exp(-2518.907570/T));
	  m_Data[12] = float(144.8516401*exp(-1976.373630/T));
	  m_Data[13] = float(131.6924226*exp(-1454.312670/T));
	  m_Data[14] = float(119.9420137*exp(-951.5873000/T));
	  m_Data[15] = float(109.4275530*exp(-467.1428600/T));
	  m_Data[16] = 100.0f;
	  m_Data[17] = float(91.53050461*exp(450.7518800/T));
	  m_Data[18] = float(83.90738129*exp(885.9605900/T));
	  m_Data[19] = float(77.03357918*exp(1306.416460/T));
	  m_Data[20] = float(70.82455967*exp(1712.857140/T));
	  m_Data[21] = float(65.20651053*exp(2105.971890/T));
	  m_Data[22] = float(60.11483889*exp(2486.405530/T));
	  m_Data[23] = float(55.49289573*exp(2854.761900/T));
	  m_Data[24] = float(51.29089355*exp(3211.607140/T));
	  m_Data[25] = float(47.46498542*exp(3557.472520/T));
	  m_Data[26] = float(43.97647930*exp(3892.857140/T));
	  m_Data[27] = float(40.79116618*exp(4218.230270/T));
	  m_Data[28] = float(37.87874413*exp(4534.033610/T));
	  m_Data[29] = float(35.21232335*exp(4840.683230/T));
	  m_Data[30] = float(32.76800000*exp(5138.571430/T));
	  m_Data[31] = 1.0f;
	  return *this;
      };

};

#endif




