/*
/--------------------------------------------------------------------
|
|      $Id: tif_msrc.h,v 1.1 2004/05/21 21:02:53 maxx Exp $
|
|      Copyright (c) 1996-2002 Ulrich von Zadow
|
\--------------------------------------------------------------------
*/

//! Custom data source for libtiff. Assumes all data is in memory at
//! start.

extern TIFF* TIFFOpenMem (unsigned char* pData,
                            int FileSize,
                            int* pCurPos);


typedef struct
{
  unsigned char* pData;
  int    CurPos;
  int    MaxFileSize;
  // used when open for reading
  int    rFileSize;
  // not NULL when open for writing
  int*   pFileSize;
  char   mode[2];
}
MemSrcTIFFInfo;
/*
/--------------------------------------------------------------------
|
|      $Log: tif_msrc.h,v $
|      Revision 1.1  2004/05/21 21:02:53  maxx
|      Initial Version of vuVolume, moderatly changed to make it compile on my windows and linux machine.
|
|      Revision 1.1  2002/11/13 01:58:22  mspindle
|      *** empty log message ***
|
|      Revision 1.5  2002/02/24 13:00:43  uzadow
|      Documentation update; removed buggy PLFilterRotate.
|
|      Revision 1.4  2000/01/10 23:52:59  Ulrich von Zadow
|      Changed formatting & removed tabs.
|
|      Revision 1.3  1999/10/03 18:50:52  Ulrich von Zadow
|      Added automatic logging of changes.
|
|
--------------------------------------------------------------------
*/
