//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef SLAVE_FORWARD_HH
#define SLAVE_FORWARD_HH

#include <stream.h>
#include "C++.hh"
#include "Forward.hh"

//=============================================================
//  Modified from SlaveObjectiveFunction:  Lydia Deng /03/10/94
//  Modified from SlaveError:  Lydia Deng /03/13/94
//	suggested by Martin Smith
//=============================================================

//@Man:
//@Memo: a class for user-defined forward operators 
/*@Doc: 
  SlaveForward
  is a class for user-defined forward operators.
  SlaveForward almost a duplicate of the class Slave-
  ObjectiveFunction in UGA developed by Martin Smith of NER.
  It provides a communication of the optimization and user-
  suppiled objective-function evaluation program.  
  The executable of this prgram is invoked by SlaveForward,
  so they can be written in any programming language. COOOL 
  does not know about this program, it only requires the 
  supply of the result. The scheme of this class is adopted 
  from that of EXPECT written by Don Libe.

  SlaveForward currently only takes Models either double 
  or long integer. It is mostly because I tried to avoid using
  templates, due to the ugliness of template features in G++.
  Hopefully, this could be changed soon.
*/

namespace coool 
{
    using namespace coool;

class SlaveForward: public Forward {
private:
    	AString		command;
    	AString		cmdargs;
    	char*		ptyfile;
    	char*		ttyfile;
    	int		master_fd;
    	int		slave_fd;
    	char*		linebuffer;

    	int		runCommand(const AString&, const AString&);
    	int		makePtyName();
    	int		getMasterFD();
    	int		getSlaveFD();

  public:
	//@ManMemo: Constructor
    	SlaveForward(///dimension of the Model space 
		     int ndim, 
		     /// number of output
		     int ndat, 
		     ///SlaveForward invokes the executable file, cmdtr
		     AString& cmdtr, 
		     ///SlaveForward invokes cmstr with arguments argstr
		     const AString& argtr, 
		     /// =1, verbose; =0, quiet
		     int verbose);
	/*@Doc: Usually ndat=1, the output is the result of 
	  objective-function evaluation.  */
    	~SlaveForward();

	//@ManMemo: returns name of the class;
	const char* 	className() const;
	//@ManMemo:  returns a list of data as a result of evaluation
    	List<double>	dataList(const Model<double>& m);
	/*@Doc: If ndat=1, dataList returns the value of objective
        function evaluation. */
    	//@ManMemo: returns a list of data as a result of evaluation 
	List<double>	dataList(const Model<long>& m);
	/*@Doc: If ndat=1, dataList returns the value of objective
        function evaluation. */
    	//@ManMemo:returns the gradient vector evaluated at the Model m
	Vector<double>*	gradient(const Model<double>& m);
    	//@ManMemo:returns the gradient vector evaluated at the Model m
	Vector<double>*	gradient(const Model<long>& m);
};

 
}

#endif
