//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef SIRT_HH
#define SIRT_HH

#include "QuaOptima.hh"

//=============================
// author:  H. Lydia Deng, 08/14/95
// Definition of the Simulaneous Iterative Reconstruction Technique (SIRT)
//=============================
//@Man:
//@Memo: Simulaneous Iterative Reconstruction Technique
/*@Doc:


*/

namespace coool 
{
    using namespace coool;

class SIRT : public QuadraticOptima {

  protected:
    int	m, n;
    Model<double> upDating(int, const Model<double>& );
    Model<long> upDating(int, const Model<long>& );

 public:
    //@ManMemo: a constructor
    SIRT(/// dimension of model space
			int n, 
			///pointer to the forward operator (matrix)
			LinearForward* p, 
			/// observed data vector
			Vector<double>* data, 
			/// maximum number of iterations in solving linear system
			int it, 
			/// the maxmimum toleratable error
			double tol, 
			///vebose or quiet
			int verb);
    //@ManMemo: a constructor
    SIRT(int n, LinearForward* p, Vector<double>* data, int it, double tol);
     ~SIRT();

    //@ManMemo: SIRT search starting from m0, and returns an optimum model
    Model<double> 	optimizer(Model<double>& m0);
    //@ManMemo: SIRT search starting from m0, and returns an optimum model
    Model<long> 	optimizer(Model<long>& m0);
};
 
}

#endif


