//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//

#ifndef ROSEN_BROCK_HH
#define ROSEN_BROCK_HH

#include "ObjFcn.hh"
#include "C++.hh"

//=============================================================
// Authors: H. Lydia Deng, Wences Gouveia
//=============================================================

//@Man:
//@Memo: the class of n-D Rosenbrock function 
/*@Doc: 
  RosenBrock
  This is an analytical function for testing optimization
  algortithms. The function looks like
  \[ \sum_{i=1}^{N-1} [100.(x_i-x_{i-1}^2)^2 + (1-x_{i-1})^2] \]
  
  RosenBrock currently only takes Models either double 
  or long integer. It is mostly because I tried to avoid using
  templates, due to the guliness of template features in G++. 
  Hopefully, this could be changed soon.
*/ 


namespace coool 
{
    using namespace coool;

class RosenBrock : public ObjectiveFunction {
private:
      double temp1(double, double);
      double temp2(double);

protected:
      ///
      double 	realPerformance(const Model<double>&);
      ///
      double 	realPerformance(const Model<long>&);

public:    			//Constructors and Destructors
      ///
      RosenBrock(int);
      ~RosenBrock();

      ///
      Vector<double>* 	getGradient(const Model<double>&);
      ///
      Vector<double>* 	getGradient(const Model<long>&);
      ///
      const char*  className() const;
};
 
}

#endif
