//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//

#ifndef QUADRATIC_OBJECTIVE_FUNCTION_HH
#define QUADRATIC_OBJECTIVE_FUNCTION_HH

#include "ObjFcn.hh"
#include "Model.hh"
#include "Matrix.hh"

//=============================================================
// Authors: H. Lydia Deng, Wences Gouveia
//=============================================================

//@Man:
//@Memo: a n-D general quadratic objective function
/*@Doc: Quadratic
is a general class of analytical quadratic 
  objective function for optimization
  \[ \min_{\bf x} f = ({\bf x}, A\,{\bf x})- 1/2 ({\bf h}, {\bf x}) +c \]

*/

namespace coool 
{
    using namespace coool;

class QuadraticObjFcn : public ObjectiveFunction {
  private:
    Matrix<double>*	coeff;
    Vector<double>*	rhs;
    double		offset;
  protected:
    ///
    double realPerformance(const Model<double>& );
    ///
    double realPerformance(const Model<long>& );

    ///
    int mySize() const { return nparam;}

  public:
    ///
    QuadraticObjFcn(int, Matrix<double>*, Vector<double>*, double);
    ~QuadraticObjFcn();

    ///
    Vector<double>*	getGradient(const Model<double>&);
    ///
    Vector<double>*	getGradient(const Model<long>&);
    ///
    const char*  className() const;
};
 
}

#endif
