//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef QUADRATIC_OPTIMA_HH
#define QUADRATIC_OPTIMA_HH

#include "Optima.hh"
#include "LinForward.hh"
#include "MisFit.hh"

//==================
//define the base class for quadratic optimization classes
//	H. Lydia Deng, 03/04/94
//======================

//@Man:
//@Memo: a base class of optimization algorithm
/*@Doc: 
  This is the base class for linear solvers included
  in COOOL. These are used to solved optimizations
  having quadratic objective function.
  Classes derived from this class inherit features of 
  QuadraticOptima. This class cannot be instantiated directly.

  QuadraticOptima currently only takes Models either double 
  or long integer. It is mostly because I tried to avoid using
  templates, due to the guliness of template features in G++. 
  Hopefully, this could be changed soon.

*/


namespace coool 
{
    using namespace coool;

class QuadraticOptima : public Optima 
{

 public:
      //@ManMemo: a constructor
      QuadraticOptima(/// dimension of Model space
		      int n, 
		      /// pointer to the LinearForward operator (matrix)
		      LinearForward* lp, 
		      /// pointer to the observed data vector
		      Vector<double>* data, 
		      /// verbose or quiet
		      int verb);
      //@ManMemo: a constructor
      QuadraticOptima(int n, LinearForward* lp, Vector<double>* data);
      virtual ~QuadraticOptima();
 
      virtual Model<double> 	optimizer(Model<double>&) = 0;
      virtual Model<long> 	optimizer(Model<long>&) = 0;
    
      //@ManMemo: number of objective function evaluations
      virtual int numIterations() {return ((MisFitFcn*)fp)->iterations();}
	 
      //@ManMemo:  get error at the current stage
      Vector<double>	currentError() {return ((MisFitFcn*)fp)->currentError();}
      Vector<double>	finalError()   { return 0;}

};
 
}

#endif


