//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef PRE_CGLS_HH
#define PRE_CGLS_HH

#include "CGLS.hh"
#include "DiagMatrix.hh"

//=============================
// author:  H. Lydia Deng, 03/14/94
// derived class from CGLS, the preconditioned CGLS
//=============================
//@Man:
//@Memo: Pre-conditioned Conjugate Gradient for Least Squares
/*@Doc: PreconditionedCGLS()
  This is a class almost identical to that of CGLS, but it handles some 
  preconditioned algorithms. 
  Currently, PreconditionedCGLS is actually used as the front-end of 
  CGLS for Irls, since Irls reduces to a sequence of conditioned CGLS.
*/

namespace coool 
{
    using namespace coool;

class PreconditionedCGLS : public LSConjugateGradient {
  private:
    DiagMatrix<double>*		weight;

  public:			
    //@ManMemo:  a constructor
    PreconditionedCGLS(/// dimension of model space
			int n, 
			///pointer to the forward operator (matrix)
			LinearForward* p, 
			/// observed data vector
			Vector<double>* data, 
			/// maximum number of iterations in solving linear system
			int it, 
			/// the maxmimum toleratable error
			double tol, 
			///vebose or quiet
			int verb);
    //@ManMemo:  a constructor
    PreconditionedCGLS(int n, LinearForward* p, Vector<double>* data, int it, double tol);
    ~PreconditionedCGLS();

    //@ManMemo: assign the pre-conditioning diagonal matrix
    void		assignWeight(DiagMatrix<double>& d){ weight[0] = d; }

    //@ManMemo: Preconditioned LS Conjugate gradient starting from m0, returns an optimum Model
    Model<double> 	optimizer(Model<double>& m0);
    //@ManMemo: Preconditioned LS Conjugate gradient starting from m0, returns an optimum Model
    Model<long> 	optimizer(Model<long>& m0);
};
 
}

#endif
