//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef OPTIMA_HH
#define OPTIMA_HH

#include "Vector.hh"
#include "List.hh"
#include "Model.hh"
#include "ObjFcn.hh"

//==================
//define the base class for  optimization classes
//	H. Lydia Deng, 03/14/94
//======================

//@Man:
//@Memo: a base class of optimization algorithm
/*@Doc: 
  This is the base class for general optimization classes.
  Classes derived from this class inherit features of 
  Optima. This class cannot be instantiated directly.

  Optima currently only takes Models either double 
  or long integer. It is mostly because I tried to avoid using
  templates, due to the guliness of template features in G++. 
  Hopefully, this could be changed soon.
*/

namespace coool 
{
    using namespace coool;

class Optima {
      protected:
      //@ManMemo: maximum number of iterations
      int  iterMax;  
      //@ManMemo: tolerance error
      double  tol;
      //@ManMemo: list of residue 
      List<double>*  residue;
      //@ManMemo: pointer to objective function
      ObjectiveFunction*  fp;
      //@ManMemo: verbose or quiet
      int  isVerbose;
      //@ManMemo: the flag indicating if the search was a success
      int  isSuccess; 
      //@ManMemo: append the new residue to the list
      List<double>  appendResidue(double res); 

public:
      //@ManMemo: 
      Optima();
      //@ManMemo: 
      Optima(int verb);
      virtual ~Optima();
    
      virtual Model<double> optimizer(Model<double>&) = 0;
      virtual Model<long>   optimizer(Model<long>&) = 0;

							//Output residues
      //ManMemo: 
      int   ifSuccess();
      //ManMemo:  residue of the last iteration
      double	finalResidue();
      //ManMemo: residue of the first iteration
      double 	firstResidue();
      //ManMemo: residues of all iterations
      List<double> 	allResidue();
      //ManMemo:  normalized residues of all iterations
      List<double> 	normResidue();
      //ManMemo:  number of iterations so far
      virtual int 	numIterations();
      //ManMemo: type of ObjectiveFunction
      virtual const char* objName();
      //ManMemo: type of Optima
      virtual const char* optName();
      virtual Vector<double>	finalError() = 0;
};
 
}

#endif
