//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
//==================
//define the base class for  optimization classes
//	H. Lydia Deng, 03/14/94
//======================

#include "Optima.hh"
#include <limits.h>

static const char*  myNameIs =  "Abstract Optima";

Optima::Optima(){ 
	residue 	= 	new List<double>; 
	isVerbose 	= 	0;
	isSuccess       =       0;
	fp		=	NULL;
	tol		=	0.;
	iterMax		=	1000;
}

Optima::Optima(int verbose){ 
	residue 	= 	new List<double>; 
	isVerbose 	= 	verbose;
	isSuccess       =       0;
	fp		=	NULL;
	tol		=	0.;
	iterMax		=	1000;
}

Optima::~Optima() { 
	delete residue;
	if (fp != NULL)  fp = NULL;
}
							//Output residues
int Optima::ifSuccess()                 {return isSuccess;}
double Optima::finalResidue()		{return residue->last();}
double Optima::firstResidue()		{return residue->first();}
List<double> Optima::allResidue()	{return *residue;}
List<double> Optima::normResidue()    	{return residue->normalize();}
int Optima::numIterations()	 	{return fp->iterations();}
const char* Optima::objName()		{return fp->className();}
const char* Optima::optName()		{return myNameIs;}

List<double> Optima::appendResidue(double res)
{
   (*residue) += res;
   return residue[0];
}      
