//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//

#ifndef OBJECTIVEFUNCTION_HH
#define OBJECTIVEFUNCTION_HH

#include "C++.hh"

//=============================================================
// Author: H. Lydia Deng
//=============================================================

//@Man:
//@Memo: a base class for general objective functions for optimizations
/*@Doc:  ObjectiveFunction currently only takes Models either double 
     or long integer. It is mostly because I tried to avoid using
     templates, due to the guliness of template features in G++. 
     Hopefully, this could be changed soon.
*/

namespace coool 
{
    using namespace coool;

class ObjectiveFunction {
  protected:
    int				nparam;
    int				niteration;
    Vector<double>*		gradient;

  public:
    virtual double realPerformance(const Model<long>&)  = 0 ;
    virtual double realPerformance(const Model<double>&) = 0;
    virtual double realPerformance(const Model<float>&) { return 0;};
    

    ///
    ObjectiveFunction(int n);
    virtual ~ObjectiveFunction(){ if (gradient != NULL) delete gradient;}

    virtual const char* 	className() const;
    ///
    double performance(const Model<long>&);
    ///
    double performance(const Model<double>&);
    ///
    double performance(const Model<float>&);

    ///
    int	iterations() const {return niteration;}
    
    virtual Vector<double>* getGradient(const Model<double>&);
    virtual Vector<double>* getGradient(const Model<float>&);
    virtual Vector<double>* getGradient(const Model<long>&);
};
 
}

#endif
