//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
//=============================================================
// Author: H. Lydia Deng
//=============================================================


#include "ObjFcn.hh"

static const char*  myNameIs =  "objective base function";

const char* ObjectiveFunction::className() const
{
    return (myNameIs);
}

ObjectiveFunction::ObjectiveFunction(int n)
{
    nparam	=	n;
    gradient	=	new Vector<double>(n);
    niteration 	= 	0;
}

Vector<double>* ObjectiveFunction::getGradient(const Model<double>& )
{
    delete		gradient;
    gradient	=	NULL;
    return	gradient;
}

Vector<double>* ObjectiveFunction::getGradient(const Model<long>&)
{
    delete		gradient;
    gradient	=	NULL;
    return		gradient;
}

Vector<double>* ObjectiveFunction::getGradient(const Model<float>&)
{
    delete		gradient;
    gradient	=	NULL;
    return		gradient;
}

double ObjectiveFunction::performance(const Model<double>& p)
{
	niteration++;
	return realPerformance(p);
}

double ObjectiveFunction::performance(const Model<long>& p)
{
	niteration++;
	return realPerformance(p);
}
double ObjectiveFunction::performance(const Model<float>& p)
{
	niteration++;
	return realPerformance(p);
}
