//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef NON_QUADRATIC_OPTIMA_HH
#define NON_QUADRATIC_OPTIMA_HH

#include "Optima.hh"

//==================
//define the base class for NonQuadratic optimization classes
//	H. Lydia Deng, 02/25/94, 03/15/94
//======================

//@Man:
//@Memo: a base class for non-quadrtic optimizer
/*@Doc:
  NonQuadraticOptima
  This is the base class for all optimization
  algorithms but those linear solvers.
  Classes derived from this class inherit features of 
  NonQuadraticOptima. This class cannot be used directly.

  NonQuadraticOptima currently only takes Models either double 
  or long integer. It is mostly because I tried to avoid using
  templates, due to the guliness of template features in G++. 
  Hopefully, this could be changed soon.

*/

namespace coool 
{
    using namespace coool;

class NonQuadraticOptima : public Optima 
{
   
   public:
   //@ManMemo: 
   NonQuadraticOptima();
   //@ManMemo: 
   NonQuadraticOptima(int);
   virtual ~NonQuadraticOptima();
 
   virtual Model<double> optimizer(Model<double>&) = 0;
   virtual Model<long> 	optimizer(Model<long>&) = 0;
   virtual Vector<double> finalError() { return 0;}
};
 
}

#endif
