//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//

#ifndef MULTI_TEST_HH
#define MULTI_TEST_HH

#include "ObjFcn.hh"
#include "C++.hh"
#include "math.h"

#ifndef PI
#define PI 3.14159265358979323846264338327950288
#endif

//SB: static const char*  myNameIs =  "multimodal test";

//=============================================================
// Author: H. Lydia Deng
//=============================================================
//@Man:
//@Memo: a simple 2-D multi-modal test function
/*@Doc: 
   MultiTest is a simple 2-D multimodal analytical function
     for testing optimization algortithms. 
     The function looks like
     \[ f = m[0]^2+2m[1]^2-0.3\cos(2\Pi m[0])-0.4\cos(4\Pi m[1]+0.7) \]

     MultiTest currently only takes Models either double 
     or long integer. It is mostly because I tried to avoid using
     templates, due to the guliness of template features in G++. 
     Hopefully, this could be changed soon.
*/

namespace coool 
{
    using namespace coool;

class MultiTest : public ObjectiveFunction 
{
   private:
   Vector<double> *acoeff, *bcoeff, *freq;
   double    offset;
      
   protected:
   ///
   double realPerformance(const Model<double>&);
   ///
   double realPerformance(const Model<long>&);

   ///
   Vector<double> wigle(const Vector<double>&, const Model<double>&);
   ///
   int mySize() const;
	
   public:    		//Constructors and Destructors
   ///
   MultiTest(int n);
   ///
   MultiTest(int n, Vector<double>&, Vector<double>&, Vector<double>&, double);
   ~MultiTest();
	
   ///
   const char*  className() const;
    
   ///
   Vector<double>* getGradient(const Model<double>&);
   ///
   Vector<double>* getGradient(const Model<long>&);
};
 
}

#endif

