//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//

#ifndef MATRIX_HH
#define MATRIX_HH

//===========================
// General Matrix class template library for basic algebraic operations
//  Lydia Deng, Wenceslau Gouveia, 01/24/94
//  Lydia Deng, 01/27/94	adding methods: rowMax, rowMin, colMax, colMin
//  Lydia Deng, 03/08/94	adding atdotx
//  Lydia Deng, 04/20/94	change to an abstract class
//===========================

#include "Vector.hh"

namespace coool
{
    
static const char*  myName0 =  "base matrix class";

//===========================================
//@Man:
//@Memo:  a general Matrix base template class
//==========================================
/*@Doc: This is a minimal class for a base class for other specific matrix 
   classes in COOOL */

//@{
template<class Type>
class Matrix {
  protected:
    int nrow, ncol;

  public:
    /// The default constructor, length 1X1
    //ManMemo: The default constructor, length 1X1
    Matrix(){ nrow = 1; ncol = 1; }
    //@ManMemo: A constructor with specified number of rows and columns
    Matrix(///number of rows
           int m, 
           ///number of columns
          int n) 
    { nrow = m; ncol = n; }
    virtual ~Matrix(){;}

    virtual const char* matrixType() const {return myName0;}

  	//@ManMemo: Fetch number of rows
    int numOfRows() const {return nrow;}
  	//@ManMemo: Fetch number of columns
    int numOfCols() const {return ncol;}

    virtual Vector<Type> rowVector( int) const =0;
    virtual Vector<Type> colVector( int) const =0;

    virtual Vector<Type> atdotx(const  Vector<Type>&) =0;
    virtual Vector<Type> adotx(const  Vector<Type>&) =0;

    virtual  Type operator() (char*,  int)  = 0;
    virtual  Type operator() (int, char*)  = 0;
    virtual  Type rowMax( int) const =0;
    virtual  Type rowMin( int) const =0;
    virtual  Type colMax( int) const =0;
    virtual  Type colMin( int) const =0;

};

//@}

}

#endif
