//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef LINE_SEARCH_HH
#define LINE_SEARCH_HH

#include "C++.hh"
#include "ObjFcn.hh"

//======================================================================
// Definition of the Linesearch class
// author: Lydia Deng
//========================================================================

//@Man:
//@Memo: an abstract class of 1-D line searches
/*@Doc: 
  This is the base class for one dimensional
  line search algorithms. Some optimization
  algorithms need to find the optimimal point
  on one searching directions.
  Classes derived from this class inherit features of 
  LineSearch. This class cannot be used directly.

  LineSearch currently only takes Models either double 
  or long integer. It is mostly because I tried to avoid using
  templates, due to the guliness of template features in G++. 
  Hopefully, this could be changed soon.

*/

namespace coool 
{
    using namespace coool;

class LineSearch {
private:
	Vector<double>*		numericalGradient(Model<double>&);
	Vector<double>*		numericalGradient(Model<long>&);

protected:
	//@ManMemo: maxinum number of iterations allowed;
	int 			iterMax;
	//@ManMemo: the number iterations so far
	int			iterNum;
	//@ManMemo: the history of number of iteration of iteration
	List<int>*		iterHistory;
	//@ManMemo: the value at the minimum
	double			value;
	//@Manmemo:
	Vector<double>*		step;
	//@ManMemo: pointer to the objective function
	ObjectiveFunction*	fp;
	
	//@ManMemo: 
	void			appendSearchNumber();

public:						

	//@ManMemo: a constructor with pointer to the objective function
    	LineSearch(///pointer to the objective function object
		   ObjectiveFunction* f, 
		   ///pointer to the interval vector for finite-difference if numerical gradient is computed
		   Vector<double>* interval);
	//@ManMemo: a constructor with a pointer to objective function
    	LineSearch(ObjectiveFunction* f);
	virtual ~LineSearch();

	virtual Model<double> 	search(Model<double>&, Vector<double>&, double, double);

	//@ManMemo:  compute the gradient Vector for Model $m$
	Vector<double>		gradient(Model<double>& m);
	//@ManMemo:  evaluate the objective function for Model $m$;
	double			evaluate(Model<double>& m);
	virtual Model<long> 	search(Model<long>&, Vector<double>&, double, double);
	//@ManMemo:  compute the gradient Vector for Model $m$
	Vector<double>		gradient(Model<long>& m);
	//@ManMemo:  evaluate the objective function for Model $m$;
	double			evaluate(Model<long>& m);

	//@ManMemo: number of iterations for all line searches.
	List<int> allSearchIterations();
	//@ManMemo: number of iterations in the current line search;
	int searchIterations();
	//@ManMemo:value of the objective function for the current Model
    	double currentValue();
	//@ManMemo: the class name of the objective function
   	const char* objName();
};
 
}

#endif
