//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
//======================================================================
// Definition of the Linesearch class
// author: Lydia Deng
//======================================================================

#define TINY	1.0e-10
#define MAX_IT	1000

#include <limits.h>
#include <float.h>
#include "LineSearch.hh"

LineSearch::LineSearch(ObjectiveFunction* p)
{
   iterMax 	= 	MAX_IT;
   iterNum 	= 	0;
   fp 		= 	p;
   step		=	0;
   iterHistory	=	new List<int>;
}

LineSearch::LineSearch(ObjectiveFunction* p, Vector<double>* interval)
{
   iterMax 	= 	MAX_IT;
   iterNum 	= 	0;
   fp 		= 	p;
   step		=	interval;
   iterHistory 	= 	new List<int>;
}

LineSearch::~LineSearch(){
    delete	iterHistory;
}

void	LineSearch::appendSearchNumber()
{
    iterHistory[0] 	+=	iterNum;
}

List<int>	LineSearch::allSearchIterations()  { return iterHistory[0];}
int 		LineSearch::searchIterations()	{return iterNum;}

double 		LineSearch::currentValue()	{return value;}
const char* 	LineSearch:: objName() 		{return (fp->className());}

Model<double> 	LineSearch::search(Model<double>& m, Vector<double>& v, 
			    double alpha,   double beta) 
{      
	cerr << "You need to specify the LineSearch method!";
	exit(1);
	return	0;
    }

Model<long> 	LineSearch::search(Model<long>& m, Vector<double>& v, 
			    double alpha,   double beta) 
{      
	cerr << "You need to specify the LineSearch method!";
	exit(1);
	return	0;
    }

Vector<double>*	LineSearch::numericalGradient(Model<double>& m)
{
    int	n 		= 	m.modSize();
    if(!step) {	//SB!!
	cerr << "For numerical gradients (finite differences) a stepsize must be specified."
	     << endl << "Creating default vector of ones." << endl;
	step = new Vector<double>(n);
	*step = 1.0f;
    }
    
    Vector<double>*	grad = new Vector<double>(n);
    double diffValue, newValue, off;
    Model<double>	m1(m);
    //SB: double currentValue	=	fp->performance(m);

    for (int i = 0; i < n; i++) {
	off		= 	step[0][i];
	m1[i] 		-= 	off;
	newValue	=	fp->performance(m1);
	m1[i]           +=      2*off;
	diffValue	=	fp->performance(m1);
	diffValue	-=	newValue;
	(*grad)[i] 	= 	diffValue/(2*off);
	m1[i]		=	m[i];
    }

//    cerr << "the gradient: "<< grad[0] <<" at model "<<m<<endl;
    return	grad;
}
 
Vector<double>*	LineSearch::numericalGradient(Model<long>& m)
{
    int	n 		= 	m.modSize();
    if(!step) {	//SB!!
	cerr << "For numerical gradients (finite differences) a stepsize must be specified."
	     << endl << "Creating default vector of ones." << endl;
	step = new Vector<double>(n);
	*step = 1.0f;
    }
    
    Vector<double>*	grad = new Vector<double>(n);
    double diffValue, newValue, off;
    Model<double>	dm(m);
    Model<double>	m1(dm);

    double currentValue	=	fp->performance(dm);
    for (int i = 0; i < n; i++) {
	off		=	step[0][i]*dm[i];
	m1[i] 		+= 	off;
	newValue	=	fp->performance(m1);
	diffValue	=	newValue-currentValue;
	(*grad)[i] 	= 	diffValue/(off);
	m1[i]		=	dm[i];
    }
    return	grad;
}
 
Vector<double>	LineSearch::gradient(Model<double>& m)
{
    Vector<double>*  g = new Vector<double>(m.modSize());
    if ( (g=(fp->getGradient(m))) == NULL)
	g 	=	numericalGradient(m);
    return g[0];
}

Vector<double>	LineSearch::gradient(Model<long>& m)
{
    Vector<double>*  g = new Vector<double>(m.modSize());
    if ( (g=(fp->getGradient(m))) == NULL)
	g 	=	numericalGradient(m);
    return g[0];
}

double	LineSearch::evaluate(Model<double>& m)
{
    return	fp->performance(m);
}

double	LineSearch::evaluate(Model<long>& m)
{
    return	fp->performance(m);
}


