//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef LINEAR_FORWARD_HH
#define LINEAR_FORWARD_HH

#include "Forward.hh"
#include "Matrix.hh"

//=============================================================
// Author:  H. Lydia Deng
//=============================================================
//@Man:
//@Memo: a linear operator class
/*@Doc:  LinForward
      is a class for linear forward operators in optimization. 
      It is, in fact, no more than a Matrix. For a quadratic
      optimization problem, this Matrix is the Hessian of
      the objective function.

      LinForward currently only takes Models either double 
      or long integer. It is mostly because I tried to avoid using
      templates, due to the guliness of template features in G++. 
      Hopefully, this could be changed soon.
*/

namespace coool 
{
    using namespace coool;

class LinearForward : public Forward {
private:
    Matrix<double>* 	jacob;

public:    		
    //@ManMemo: construct a LinearForward with a matrix A
    LinearForward(Matrix<double>* A);
    //@ManMemo: construct a LinearForward with a matrix A
    LinearForward(Matrix<double>* A, int verb);
    ~LinearForward(){ delete jacob;}

    //@ManMemo: dimension of the Model space
    int	modelSize() const { return jacob->numOfCols();}
    //@ManMemo: dimension of Data space, number of observed data
    int	dataSize() const { return jacob->numOfRows();}
    //@ManMemo: the ith row of the linear operator
    Vector<double> oneOperator(int i) { return jacob->rowVector(i); }
    //@ManMemo: returns the class name for this the object
    const char*  	className() const;

    //@ManMemo: list of the calculated data when applied the operator to Model m
    List<double> dataList(const Model<double>& m);
    //@ManMemo: list of the calculated data when applied the operator to Model m
    List<double> dataList(const Model<long>& m);
    //@ManMemo: apply adjoint of the linear operator to data Vector v
    Vector<double> adjointOp(const Vector<double>& v);
    //@ManMemo: apply adjoint of the linear operator to data Vector v
    Vector<double> adjointOp(const Vector<long>& v);
    //@ManMemo: apply the ith row of linear operator to data Vector v
    double forwardOp(int i, const Vector<double>& v);
    //@ManMemo: apply the ith row of linear operator to data Vector v
    double forwardOp(int i, const Vector<long>& v);
    //@ManMemo: apply the linear operator to data Vector v
    Vector<double> forwardOp(const Vector<double>& v);
    //@ManMemo: apply the linear operator to data Vector v
    Vector<double> forwardOp(const Vector<long>& v);
};
 
}

#endif
