//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
//=============================================================
// Author: H. Lydia Deng
// Implementation of a objective function class
// Implementation of linear operators as objective function for optimization
//=============================================================

#include "Forward.hh"
#include "LinForward.hh"

namespace coool 
{
    using namespace coool;

static const char*  myNameIs =  "LinearForward";

const char* LinearForward::className() const{ return (myNameIs);}
    
LinearForward::LinearForward(Matrix<double>* pm)
: Forward()
{
	int m = pm->numOfRows();
//	int n = pm->numOfCols();

	ndata = m;
	jacob = pm;
}

LinearForward::LinearForward(Matrix<double>* pm, int verbose)
: Forward(verbose)
{
	int m = pm->numOfRows();
//	int n = pm->numOfCols();

	ndata = m;
	jacob = pm;
}

Vector<double>	LinearForward::adjointOp(const Vector<double>& v)
{
    return jacob->atdotx(v);
}

Vector<double>	LinearForward::adjointOp(const Vector<long>& v)
{
   Vector<double> u(v);
   return jacob->atdotx(u);
}

double	LinearForward::forwardOp(int i, const Vector<double>& v)
{
   Vector<double> a(jacob->rowVector(i));
   return a*v;
}

double	LinearForward::forwardOp(int i, const Vector<long>& v)
{
   Vector<double> a(jacob->rowVector(i)), u(v);
   return a*u;
}

Vector<double>	LinearForward::forwardOp(const Vector<double>& v)
{
    return jacob->adotx(v);
}

Vector<double>	LinearForward::forwardOp(const Vector<long>& v)
{
   Vector<double> u(v);
   return jacob->adotx(u);
}

List<double> LinearForward::dataList(const Model<double>& p)
{
    Vector<double> v(forwardOp(p.modParam()));
    List<double> l(ToList(v));
    return l;
}

List<double> LinearForward::dataList(const Model<long>& p)
{
   Vector<double> v(forwardOp(p.modParam()));
   List<double> l(ToList(v));
   return l;
}
 
}
