//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef IRLS_HH
#define IRLS_HH

#include "PreCGLS.hh"

//=============================
// author:  H. Lydia Deng, 03/06/94, 03/14/94
// Definition of the IRLS
//=============================

//@Man:
//@Memo: Iterative reweighted least squares 
/*@Doc:
    This algorithm gives you the flexibility to choose 
    different norms (other than the norm 2) to solve 
    linear systems. A comprehensible description of
    this method can be found in "Robust methods in inverse
    theory", 1988, Inverse Problems 4, by J. Scales and A.
    Gersztenkorn.

    This procedure is not fully tested at the current stage.
*/

namespace coool 
{
    using namespace coool;

class IterativeReweightedLS : public QuadraticOptima {
private:
    PreconditionedCGLS*		pcgls;
    DiagMatrix<double>*		weight;
    double			taper;
    int				niterWeight;
    int				order;
    int                         numIter;
    
    void			updateWeight(Vector<double>&);

public:			
    //@ManMemo: a constructor
    IterativeReweightedLS(/// dimension of model space
			  int n, 
			  /// pointer to the forward operator (matrix)
			  LinearForward* p, 
			  /// observed data vector
			  Vector<double>* data, 
			  /// lp norm
			  int lp, 
			  /// number of out-loop iterations
			  int w_nit, 
			  /// maximum number of iterations in solving linear system 
			  int nit, 
			  /// a parameter
			  double tape, 
			  /// the maxmimum toleratable error
			  double tol,
			  /// verbose or quiet
			  int verb);
    //@ManMemo: a constructor
    IterativeReweightedLS(int n, LinearForward* p, Vector<double>* data, int lp, int w_nit, int nit, double tape, double tol);
    ~IterativeReweightedLS() { delete pcgls; delete weight;}

    //@ManMemo: IRLS search starting from m0, returns an optimum model
    Model<double> optimizer(Model<double>& m0);
    //@ManMemo: IRLS search starting from m0, returns an optimum model
    Model<long> optimizer(Model<long>& m0);

    int numIterations() { return numIter;};
    
};
 
}

#endif

