//============================================================
// COOOL           version 1.2           ---     Feb,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//

#ifndef GRIE_WANK_HH
#define GRIE_WANK_HH

#include "ObjFcn.hh"
#include "C++.hh"

//=============================================================
// Author: H. Lydia Deng
//=============================================================

//@Man:
//@Memo: Griewank function class
/*@Doc:

*/

namespace coool 
{
    using namespace coool;

class Griewank : public ObjectiveFunction {

protected:
      ///
      double 	realPerformance(const Model<double>&);
      ///
      double 	realPerformance(const Model<float>&);
      ///
      double 	realPerformance(const Model<long>&);

public:    			//Constructors and Destructors
      ///
      Griewank(int);
      ~Griewank();

      ///
      Vector<double>* 	getGradient(const Model<double>& m);
      ///
      Vector<double>* 	getGradient(const Model<float>& m);
      ///
      Vector<double>* 	getGradient(const Model<long>& m);
      ///
      const char*  className() const;
};
 
}

#endif
