//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
#ifndef FORWARD_HH
#define FORWARD_HH

#include "Vector.hh"
#include "List.hh"
#include "Model.hh"

const long              magic_tag       = 	0xf0f0;

//=============================================================
// Author: H. Lydia Deng
//=============================================================

//@Man:
//@Memo: a class for forward operators in optimization
/*@Doc: Forward
      is a class for forward operators in optimization. 
      Currently, COOOL takes two classes of Forward operators: 
      SlaveForward which communicates with a user-defined 
      objective-function evaluation programs, and LinForward 
      which is a Matrix for linear optimization problems.
      This class cannot not be used directly.
      
      Forward currently only takes Models either double 
      or long integer. It is mostly because I tried to avoid using
      templates, due to the guliness of template features in G++. 
      Hopefully, this could be changed soon.

*/

namespace coool 
{
    using namespace coool;

class Forward {
private:
	long 			secret_identifier;
protected:
	int 			ndata;
	int			isVerbose;

  public:
	//@ManMemo:  default constructor
    	Forward();
	//@ManMemo:  default verbose constructor
    	Forward(int verb);
    	virtual ~Forward() { secret_identifier = ~magic_tag;}

	//@ManMemo:  check if verbose or quiet
   	int 			isValid() const; 
	//@ManMemo:  set verbose status
    	void 			verbose(const int);
    virtual const char* 	className() const;

    	virtual List<double>	dataList(const Model<long>& ) = 0;
    	virtual List<double>	dataList(const Model<double>& ) = 0;

	//@ManMemo:  length of the observed data list 
    	int	 		experiments() {return ndata;}
	virtual Vector<double>	adjointOp(const Vector<double>& ) {return 0;}
	virtual Vector<double>	forwardOp(const Vector<double>& ) {return 0;}
	virtual Vector<double>	forwardOp(const Vector<long>& ) {return 0;}
	virtual double  	forwardOp(int, const Vector<double>& ) {return 0;}
	virtual double	        forwardOp(int, const Vector<long>& ) {return 0;}

	virtual Vector<double>  oneOperator(int) { return 0; }


};
 
}

#endif
