//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
//================================================================
//  Author: H. Lydia Deng
//================================================================

#ifndef DIRECT_OBJECTIVE_FUNCTION_HH
#define DIRECT_OBJECTIVE_FUNCTION_HH

#include "C++.hh"
#include "SlaveForward.hh"
#include "ObjFcn.hh"

//*****************************************************************
//@Man:
//@Memo: a class of customerized objective function
/*@Doc: This is a class of customerized objective function
     passes through SlaveForward. When the user-written
     objective-function evaluation code is used for the
     optimization, this class should be used for passing 
     values to the optimizer.
     See also SlaveForward, ObjFcn.
    
     Both value and derivatives can be passed through this 
     class. You can choose either providing your own derivative
     evaluation or using the finite-difference scheme provided 
     by COOOL. 
*/

namespace coool 
{
    using namespace coool;

class DirectObjFcn: public ObjectiveFunction {
 private:
    SlaveForward*  forOp;
    int	isUpdated;
    // this is a flag indicating if derivative is given by the user
    int given_g;    
    
 protected:
    //@ManMemo: 
    double 	realPerformance(const Model<long>& m);
    //@ManMemo: 
    double 	realPerformance(const Model<double>& m);
    //@ManMemo: 
    Vector<double>*  getGradient(const Model<double>& m);
    //@ManMemo: 
    Vector<double>*  getGradient(const Model<long>&  m);
    
 public:
    //@ManMemo: construct a custermerized objective function from SlaveForward operator
    DirectObjFcn(///dimension of the Model space
		 int n, 
		 ///pointer to the SlaveForward in which communication to evaluation codes are provided
		 SlaveForward* fp, 
		 ///a flag indicating if the user provides gradient information
		 int given_g);
    /*@Doc: This constructor is important when the user can provide the 
      evaluations of  the objective function. When $given_g=1$, the user-defined  
      gradient evaluation is available. Otherwise by default, $given_g=0$, 
      COOOL calculates gradient vectors by a finite-difference scheme. */

    //@ManMemo: construct a custermerized objective function from SlaveForward operator with default $given_g=0$
	DirectObjFcn(int n, SlaveForward* fp);
	~DirectObjFcn();

    //@ManMemo: 
    	const char* 	className() const;
    //@ManMemo: 
    	const char* 	forwardName() const;
};
 
}

#endif
