//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
//=============================================================
// Author: H. Lydia Deng
//=============================================================

#include "DirectObjFcn.hh"

static const char*  myNameIs =  "DirectObjFunction";

const char* DirectObjFcn::className() const { 
	return (myNameIs);
}

const char* DirectObjFcn::forwardName() const { 
	return forOp->className();
}

DirectObjFcn::DirectObjFcn (int n, SlaveForward* forwardOp)
: ObjectiveFunction(n)
{
   isUpdated = 0;
   forOp = forwardOp;
   given_g = 0;
}

DirectObjFcn::DirectObjFcn (int n, SlaveForward* forwardOp, int ig)
: ObjectiveFunction(n)
{
   isUpdated	=	0;
   forOp		= 	forwardOp;
   given_g = ig;
}

DirectObjFcn::~DirectObjFcn()
{
   forOp = NULL;
}

double DirectObjFcn::realPerformance(const Model<double>& p)
{
   List<double> ldat = forOp->dataList(p);
   return ldat[0];
}

double DirectObjFcn::realPerformance(const Model<long>& p)
{
   List<double> ldat = forOp->dataList(p);
   return ldat[0];
}

Vector<double>* DirectObjFcn::getGradient(const Model<double>& p)
{
   Vector<double>* g;
   if (!given_g)  return NULL;
   g  = new Vector<double>(p.modSize());
   g  = forOp->gradient(p);
   return g;
}

Vector<double>* DirectObjFcn::getGradient(const Model<long>& p)
{
   Vector<double>* g;
   if (!given_g)  return NULL;
   g  = new Vector<double>(p.modSize());
   g  = forOp->gradient(p);
   return g;
}
