//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
//=============================
// Definition of the conjugate gradient class
// Non-linear conjugate gradient algorithm
// author:  Wenceslau Gouveia
// modified:  H. Lydia Deng, 02/23/94,  /03/14/94
//=============================

// .NAME ConjugateGradient class
// .LIBRARY Base
// .HEADER Optimization Algorithms
// .INCLUDE defs.hh
// .FILE CG.hh

// .SECTION Description
// .B ConjugateGradient()
// The conjugate gradient procedure implemented in this object is an extension of
// the conjugate gradient used in linear system solving to handle non quadratic
// objective functions. Such extensions amount basically to the inclusion of a 
// line search step and a modification in the computation of the conjugate directions.
// Details can be found in the classic (and tough!) book Practical Optimization by
// Powell.
// 
// .SECTION Description
// Public Operations
// Constructors: 
//		ConjugateGradient(LineSearch* ls, int iter, double tol)
// 		Here:
//			ls: Defines the line search used. At the present version you should use the
//			    CubicLineSearch procedure.
//			iter: Maximum number of iterations
//		 	tol: Minimum accepted module of the gradient at optimum solution
// Methods:
//		Model<>ConjugateGradient::optimizer(Model<double>&)
//		Here:
//			model0:  Initial model for the conjugate gradient procedure.
//
//			The optimum model is returned by the function.
//
// .SECTION Caveats
// This procedure requires the derivatives of the objective function. At the present version the
// COOOL library cannot handle analytic derivatives provided by the user. Here the derivatives
// are computed numerically by a centered finite differencing scheme in a automatic fashion. 
// The hability to support user-provided derivatives will hopefully be 
// implemented in the near future.

#ifndef CONJUGATE_GRADIENT_HH
#define CONJUGATE_GRADIENT_HH

#include "LSearchOptima.hh"

//@Man:
//@Memo: Nonlinear Conjugate Gradient 
/*@Doc:
    This conjugate gradient procedure implemented in this 
    object is an extension of the conjugate gradient 
    used in linear system solving to handle non quadratic
    objective functions. Such extensions amount basically
    to the inclusion of a line search step and a 
    modification in the computation of the conjugate directions.
    Details can be found in the classic (and tough!) book 
    Practical Optimization by Powell.

    This procedure requires the derivatives of the objective function. 
    The current release of COOOL can handle analytic gradient information 
    provided by the user through communication with SlaveForward. However, 
    if the gradient cannot be computed, COOOL can compute the gradient using 
    a centered finite difference scheme.

*/
namespace coool 
{
    using namespace coool;

class ConjugateGradient : public LineSearchOptima 
{
   public:
   
   //@ManMemo: a constructor
   ConjugateGradient(///pointer to the line-search object.
		     LineSearch* ls, 
		     ///Maximum number of iterations
		     int iter, 
		     ///minimum accepted gradient at optimum solution
		     double tol,
		     ///vebose or quiet
		     int verb);
   /*@Doc: At the present version, you should use the CubicLineSearch 
     procedure */
   //@ManMemo: a constructor
   ConjugateGradient(LineSearch* ls, int iter, double tol);
    ~ConjugateGradient(){;}

   //@ManMemo: conjugate gradient search starting from m0, returns an optimum Model 
    Model<double> optimizer(Model<double>& m0);
    Model<long> optimizer(Model<long>& m0);

   //@ManMemo: 
    const char*	className() const;
};
 
}

#endif

