//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
//======================================================================
// Definition of the BrentLineSearch class
// Brent's line search algorithm
// author: Wenceslau Gouveia, Adapted from Numerical Recipes in C
// Modified to fit into new classes.  H. Lydia Deng, 02/21/94, 03/15/94
//========================================================================

// .NAME BrentLineSearch class
// .LIBRARY Base
// .HEADER Optimization Algorithms
// .INCLUDE defs.hh
// .FILE BrentLineSearch.hh

// .SECTION Description
// .B BrentLineSearch()
// This routine, inpired by the Numerical Recipes book, performs a unidimensional search
// for the minimum of the objective function along a specified direction. The minimum is
// at first bracket using the Golden search procedure. After bracketing the Brent's 
// algorithm is used to isolate the minimum to a fractional precision of about the specified 
// tolerance.
// 
// .SECTION Description
// Public Operations
// Constructors: 
//		BrentLineSearch (ObjectiveFunction *f, int iter);
// 		Here:
//			f: Define the objective function
//			iter: Maximum number of iterations
// Methods:
//		model <> BrentLineSearch::search(Model<double>& model0, Vector<double>& direction, 
//						  	                 double tol, double delta)
//		Here:
//			model0:  Initial model to initiate the bracketing procedure
// 			direction: Vector that defines the direction of the line search
//			tol: The minimum is within the returned value +/- tol
//			delta: Used in the bracketing procedure. The initial interval
//				  for the bracketing is from 0 to delta * STEP_MAX, where
//				  STEP_MAX is hard coded to 5.
//
//			The sought minimum is returned by the function.
//
// .SECTION Caveats
// This line search was not thoroughly tested. The CubicLineSearch procedure, that requires
// certain derivative information on the objective function (that can be provided by numerical
// methods has demonstrated to be a  more efficient line search procedure.

#include "defs.hh"
#include <stdio.h>

#ifndef BRENT_LINE_SEARCH_HH
#define BRENT_LINE_SEARCH_HH

#include "LineSearch.hh"

//@Man:
//@Memo: BrentLineSearch class
/*@Doc:
   BrentLineSearch class was inpired by the Numerical Recipes book, 
   performs an unidimensional search for the minimum of the objective 
   function along a specified direction. The minimum is at first
   bracket using the Golden search procedure. After bracketing 
   the Brent's algorithm is used to isolate the minimum to a 
   fractional precision of about the specified tolerance.

   This line search was not thoroughly tested. The 
   CubicLineSearch procedure, that requires certain 
   derivative information on the objective function
   (that can be provided by numerical methods) has
   demonstrated to be a  more efficient line search procedure.

*/


class BrentLineSearch : public LineSearch 
{
   public:				
   //@ManMemo: a constructor
   BrentLineSearch(///pointer to an objective fuunction class
		   ObjectiveFunction* f, 
		   ///maximum number of iterations allowed in search
		   int iter);
   ~BrentLineSearch();

				// Implementation of the Brent Search
   //@ManMemo: search for minimum model along a 1-D direction
   Model<double> search(///initial model to initiate the bracketing procedure
			Model<double>& m0, 
			///the direction of the line search
			Vector<double>& direction, 
			///the minimum is within the returned value +/- tol
			double tol, 
			///a parameter used in the bracketing procedure
			double delta);
   /*@Doc: The initial interval for the bracketing is from $0$ to 
   $delta \times STEP\_MAX$, where $STEP\_MAX$ is hard coded to $5$.
   The sought minimum is returned by the function.  */
   //@ManMemo: search for minimum model along a 1-D direction
   Model<long> search(Model<long>&, Vector<double>&, double, double);
    
};

#endif
