//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
//=============================
// author:  H. Lydia Deng, 06/17/96
//=============================

#ifndef BFGS_HH
#define BFGS_HH

#include "LSearchOptima.hh"

//@Man:
//@Memo: BFGS Quasi-Newton Optimization Method
/*@Doc: At the present version, you should use the CubicLineSearch 
  procedure */

namespace coool 
{
    using namespace coool;

class BFGS : public LineSearchOptima 
{
   public:
   
   //@ManMemo: a constructor
   BFGS(///pointer to the line-search object.
		     LineSearch* ls, 
		     ///Maximum number of iterations
		     int iter, 
		     ///minimum accepted gradient at optimum solution
		     double tol,
		     ///vebose or quiet
		     int verb);
   //@ManMemo: a constructor
   BFGS(LineSearch* ls, int iter, double tol);
   ~BFGS(){;}
   
   //@ManMemo: the BFGS search starting from model0, returns an optimum model 
   Model<double> optimizer(Model<double>& model0);
   //@ManMemo:
   Model<long> optimizer(Model<long>& model0);

   //@ManMemo: 
   const char*	className() const;
};
 
}

#endif

