//============================================================
// COOOL           version 1.1           ---     Nov,  1995
//   Center for Wave Phenomena, Colorado School of Mines
//============================================================
//
//   This code is part of a preliminary release of COOOL (CWP
// Object-Oriented Optimization Library) and associated class 
// libraries. 
//
// The COOOL library is a free software. You can do anything you want
// with it including make a fortune.  However, neither the authors,
// the Center for Wave Phenomena, nor anyone else you can think of
// makes any guarantees about anything in this package or any aspect
// of its functionality.
//
// Since you've got the source code you can also modify the
// library to suit your own purposes. We would appreciate it 
// if the headers that identify the authors are kept in the 
// source code.
//
// from Martin Smith's  AString class 
//======================

#ifndef _AString_hh
#define _AString_hh

#include "defs.hh"

// .NAME AString - simple string class
// .LIBRARY c++u
// .HEADER c++ utility classes
// .INCLUDE c++/AString.hh
// .FILE AString.cc

// .SECTION Description
// .B AString
// is a simple string class that manages its own storage.
// It allows concatenation of strings using + and +=,
// assignment using =, and equality tests using ==.

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

//@Man:
//@Memo: a simple string class that manages its own storage
/*@Doc:  This is a simple string class that manages its own storage.
 It allows concatenation of strings using + and +=,
 assignment using =, and equality tests using ==.
*/

namespace coool 
{
    using namespace coool;

class AString 
{
   private:
   
   //@ManMemo: the number of chars in s. -1 -> not known      
   int		len;		
   //@ManMemo: amount of memory allocated for this string
   int		mem;		
   //@ManMemo: grab memory in hunks of this size
   int		chunk_size;
    
   ///
      void	bigEnough(const int);
   ///
       void	initVars();
   ///
      int		inRange(const long) const;
   //@ManMemo: assigns to len.
   void	length(const int new_length); 

  protected:
    //@ManMemo: the internal string
    char*	contents; 

   //@ManMemo:  type conversion constructor
   AString(const char);
   ///
   int		compare(const AString&) const;
   ///
   int		compare(const char*) const;
   ///
   void	concat(const AString&);
   ///
   void	concat(const char*);
   ///
   void	concat(const char&);
   ///
   void	copy(const AString&);
   ///
   void	copy(const char*);
   ///
   void	copy(const char&);
   ///
   int		isNull() const;
  public:

   //@ManMemo: default constructor
   AString();			
   //@ManMemo:  type conversion constructor
   AString(const char*);	
   //@ManMemo:  copy constructor
   AString(const AString&);	
   ~AString();			

   //@ManMemo:  what size hunks is memory grabbed in
    int		chunksize() const; 
   //@ManMemo:  change size of memory hunks
    void	chunksize(const int new_size); 
   //@ManMemo:  is the string empty or NULL
    int		empty() const;		       
   //@ManMemo:  how many chars in AString
    int		length() const;		       
   
   //@ManMemo: Class name
   const char* className() const;
   //@ManMemo:  assignment
    AString& 	operator=(const AString&);     
   //@ManMemo:  assignment
    AString& 	operator=(const char*);	       
   //@ManMemo:  return ith char, i < length()
    const char&	operator[](const long i)const;  
   //@ManMemo:  concatenation
    AString&	operator+=(const AString&);    
   //@ManMemo:  concatenation
    AString&	operator+=(const char*);       
   //@ManMemo:  conversion function
    operator const char*() const;
   //@ManMemo:  convert to lower cases
   AString	asLowerCase() const;

   //@ManMemo:  concatenation
friend AString operator+(const AString&, const AString&);
   //@ManMemo:  concatenation
friend AString operator+(const AString&, const char*);
   //@ManMemo:  concatenation
friend AString operator+(const char*, const AString&);

   //@ManMemo:  equality
friend int operator==(const AString&, const AString&);
   //@ManMemo:  equality
friend int operator==(const AString&, const char*);
   //@ManMemo:  equality
friend int operator==(const char*, const AString&);

friend int operator!=(const AString&, const AString&);
   //@ManMemo:  inequality
friend int operator!=(const AString&, const char*);
   //@ManMemo:  inequality
friend int operator!=(const char*, const AString&);

   //@ManMemo:  greater than
friend int operator>(const AString&, const AString&);
   //@ManMemo:  greater than
friend int operator>(const AString&, const char*);
   //@ManMemo:  greater than
friend int operator>(const char*, const AString&);

   //@ManMemo:  greater than or equal to
friend int operator>=(const AString&, const AString&);
   //@ManMemo:  greater than or equal to
friend int operator>=(const AString&, const char*);
   //@ManMemo:  greater than or equal to
friend int operator>=(const char*, const AString&);

   //@ManMemo:   less than
friend int operator<(const AString&, const AString&);
   //@ManMemo:   less than
friend int operator<(const AString&, const char*);
   //@ManMemo:   less than
friend int operator<(const char*, const AString&);

   //@ManMemo:  less than or equal to
friend int operator<=(const AString&, const AString&);
   //@ManMemo:  less than or equal to
friend int operator<=(const AString&, const char*);
   //@ManMemo:  less than or equal to
friend int operator<=(const char*, const AString&);

   //@ManMemo:  stream I/O
friend ostream& operator<<(ostream&, const AString&);
   //@ManMemo:  stream I/O
friend istream& operator>>(istream&, AString&); 
};

AString ASFormat(char*, ...);
AString toAS(unsigned char);
AString toAS(char);
AString toAS(unsigned short);
AString toAS(short);
AString toAS(unsigned int);
AString toAS(int);
AString toAS(unsigned long);
AString toAS(long);
AString toAS(double);
 
}

#endif

