
//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------

float4x4 g_mWorld;					// World matrix for object
float4x4 g_mView;			        // View matrix
float4x4 g_mProjection;				// Projection matrix
float4x4 g_mWorldViewProjection;	// World * View * Projection matrix
float4x4 g_mWorldViewProjectionPrev;

texture	g_DiffuseMap;

float3	g_CamPos;

#define SKY_BRIGHTNESS	5.0

//-----------------------------------------------------------------------------
// Texture samplers
//-----------------------------------------------------------------------------
sampler DiffuseSampler = 
sampler_state
{
    Texture = <g_DiffuseMap>;
    MinFilter = Linear;  
    MagFilter = Linear;

    AddressU = Wrap;
    AddressV = Wrap;
};
   

//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position		: POSITION;		// vertex position 
    float3 WorldPos		: TEXCOORD0;
};

//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT RenderSceneVS( float4 vPos : POSITION, float4 vTexCoords : TEXCOORD0 )
{
    VS_OUTPUT Output;
    
	float4x4 mSkyBoxView = g_mView;
	
	mSkyBoxView[3][0] = 0;
	mSkyBoxView[3][1] = 0;//-200;
	mSkyBoxView[3][2] = 0;
	
	Output.Position = mul(vPos, mSkyBoxView);
	
	Output.Position = mul(Output.Position, g_mProjection);
    
    Output.WorldPos = vPos;
    
    return Output;
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};


PS_OUTPUT RenderScenePS( VS_OUTPUT In, uniform bool bBrightSun ) 
{ 
    PS_OUTPUT Output;
    
    Output.RGBColor = texCUBE( DiffuseSampler, In.WorldPos ) * SKY_BRIGHTNESS;
  
    return Output;
}


PS_OUTPUT WriteDepthPS( VS_OUTPUT In ) 
{ 
    PS_OUTPUT Output;
    
	Output.RGBColor = 0;
  
    return Output;
}

PS_OUTPUT WriteScreenVelocityPS( VS_OUTPUT In ) 
{ 
    PS_OUTPUT Output;
    
	float4 SSPosCurr = mul(In.WorldPos, g_mWorldViewProjection);
	float4 SSPosPrev = mul(In.WorldPos, g_mWorldViewProjectionPrev);
	
	SSPosCurr /= SSPosCurr.z;
	SSPosPrev /= SSPosPrev.z;
	
	Output.RGBColor.rg = clamp( (SSPosCurr - SSPosPrev) * float4(0.5,0.5,0,0), -0.02, 0.02 );
        
    Output.RGBColor.ba = 0;
  
    return Output;
}

     

//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique RenderScene_High
{
    pass P0
    {       
		//ZEnable = false;
		AlphaBlendEnable = false;   
		VertexShader = compile vs_1_1 RenderSceneVS();
        PixelShader  = compile ps_2_0 RenderScenePS( true );
    }
}

technique RenderScene_Medium
{
    pass P0
    {       
		AlphaBlendEnable = false;   
		VertexShader = compile vs_1_1 RenderSceneVS();
        PixelShader  = compile ps_2_0 RenderScenePS( true );
    }
}

technique RenderScene_Low
{
    pass P0
    {       
		AlphaBlendEnable = false;   
		VertexShader = compile vs_1_1 RenderSceneVS();
        PixelShader  = compile ps_2_0 RenderScenePS( false );
    }
}

technique DepthPass
{
    pass P0
    {       
		AlphaBlendEnable = false;   
		VertexShader = compile vs_1_1 RenderSceneVS();
        PixelShader  = compile ps_2_0 RenderScenePS( false );
    }
}

technique WriteDepth
{
    pass P0
    {       
		AlphaBlendEnable = false;   
		VertexShader = compile vs_1_1 RenderSceneVS();
        PixelShader  = compile ps_1_4 WriteDepthPS();
    }
}

technique WriteScreenVelocity
{
    pass P0
    {        
        VertexShader = compile vs_1_1 RenderSceneVS();
        PixelShader  = compile ps_2_0 WriteScreenVelocityPS();
    }
}


