
//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------

float4x4 g_mWorld;					// World matrix for object
float4x4 g_mView;			        // View matrix
float4x4 g_mProjection;				// Projection matrix
float4x4 g_mWorldViewProjection;	// World * View * Projection matrix

texture	g_DiffuseMap;

float3	g_CamPos;

//-----------------------------------------------------------------------------
// Texture samplers
//-----------------------------------------------------------------------------
sampler DiffuseSampler = 
sampler_state
{
    Texture = <g_DiffuseMap>;
    MinFilter = Linear;  
    MagFilter = Linear;

    AddressU = Clamp;
    AddressV = Clamp;
    AddressW = Clamp;
};
   

//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position		: POSITION;		// vertex position 
    float3 WorldPos		: TEXCOORD0;
};

//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT RenderSceneVS( float4 vPos : POSITION )
{
    VS_OUTPUT Output;

	float4x4 mSkyBoxView = g_mView;
	
	mSkyBoxView[3][0] = 0;
	mSkyBoxView[3][1] = 0; //-50;
	mSkyBoxView[3][2] = 0;
	
	Output.Position = mul(vPos, mSkyBoxView);
	
	Output.Position = mul(Output.Position, g_mProjection);
    
    Output.WorldPos = vPos;// - float3(0,50,0);
    
    return Output;
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
PS_OUTPUT RenderScenePS( VS_OUTPUT In ) 
{ 
    PS_OUTPUT Output;
    
    //Output.RGBColor = texCUBE( DiffuseSampler, In.WorldPos );
    
    //Output.RGBColor *= float4( 500,500,500,1 );

    return Output;
}


//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique RenderScene_High
{
    pass P0
    {       
		//ZEnable = false;
		AlphaBlendEnable = false;   
		VertexShader = compile vs_1_1 RenderSceneVS();
        PixelShader  = compile ps_2_0 RenderScenePS();
    }
}

/*
technique DepthPass
{
    pass P0
    {       
		AlphaBlendEnable = false;   
		VertexShader = compile vs_1_1 RenderSceneVS();
        PixelShader  = compile ps_1_1 RenderScenePS();
    }
}
*/

