//-----------------------------------------------------------------------------
// Global variables
//-----------------------------------------------------------------------------

texture g_sourceTexture;

//-----------------------------------------------------------------------------
// Texture samplers
//-----------------------------------------------------------------------------
sampler SourceSampler = 
sampler_state
{
    Texture = <g_sourceTexture>;
    MinFilter = POINT;  
    MagFilter = POINT;

    AddressU = Clamp;
    AddressV = Clamp;
};

//-----------------------------------------------------------------------------
// Name: InvertPS 
// Type: Pixel shader                                      
// Desc: 
//-----------------------------------------------------------------------------
float4 InvertPS( float2 OriginalUV : TEXCOORD0 ) : COLOR
{
    // Lookup the color at this new spot
   //return float4(1,1,1,1) - tex2D( SourceSampler, OriginalUV );    
   
	float3 vColour2 = tex2D( SourceSampler, OriginalUV ) * 1.5;    
   
	float3 vColour = (vColour2.x + vColour2.y + vColour2.z) / 3;
	
	vColour = lerp( vColour, vColour2, 0.2 );
   
	float fUpTex = OriginalUV.y * 64;
   
	float fInt;
   
	fUpTex = modf(fUpTex, fInt);
   
	if (fUpTex > 0.5)
	{
		vColour *= 0.75;
	}
      
	return float4(vColour,1);
}

//-----------------------------------------------------------------------------
// Name: RenderScene
// Type: Technique                                     
// Desc: 
//-----------------------------------------------------------------------------
technique RenderScene
{
    pass P0
    {        
        PixelShader = compile ps_2_0 InvertPS();
    }
}


