
float4x4	g_mWorld;                  // World matrix for object
float4x4	g_mWorldViewProjection;    // World * View * Projection matrix

float3		g_CamPos;


struct VS_OUTPUT
{
    float4 Position		: POSITION;		// vertex position 
    float3 CamToFrag	: TEXCOORD0;
};


VS_OUTPUT WriteDepthVS( float4 vPos : POSITION )
{
    VS_OUTPUT Output;

    Output.Position = mul(vPos, g_mWorldViewProjection);
    
    Output.CamToFrag = mul(vPos, g_mWorld) - g_CamPos;
        
    return Output;    
}

struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};

PS_OUTPUT WriteDepthPS( VS_OUTPUT In ) 
{ 
    PS_OUTPUT Output;

	Output.RGBColor = length( In.CamToFrag );

    return Output;
}

technique WriteDepth
{
    pass P0
    {   
		VertexShader = compile vs_1_1 WriteDepthVS();     
		PixelShader = compile ps_2_0 WriteDepthPS();
    }
}
