
//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------

float4x4 g_mWorld;                  // World matrix for object
float4x4 g_mWorldViewProjection;    // World * View * Projection matrix

float4	g_Colour;

texture g_sourceTexture;
texture g_DiffuseMap;

//-----------------------------------------------------------------------------
// Texture samplers
//-----------------------------------------------------------------------------
sampler SourceSampler = 
sampler_state
{
    Texture = <g_sourceTexture>;
    MinFilter = POINT;  
    MagFilter = POINT;

    AddressU = Clamp;
};
   
sampler DiffuseSampler = 
sampler_state
{
    Texture = <g_DiffuseMap>;
    MinFilter = Linear;  
    MagFilter = Linear;

    AddressU = Clamp;
};
   
//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position		: POSITION;		// vertex position 
};

//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT RenderSceneVS( float4 vPos : POSITION )
{
    VS_OUTPUT Output;

    // Transform the position from object space to homogeneous projection space
    Output.Position = mul(vPos, g_mWorldViewProjection);
    
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
PS_OUTPUT RenderScenePS( VS_OUTPUT In ) 
{ 
    PS_OUTPUT Output;
    
    Output.RGBColor = float4(1,0,0,1);

    return Output;
}



float4 CopyPS( float2 OriginalUV : TEXCOORD0 ) : COLOR
{
    // Lookup the color at this new spot
    return tex2D( SourceSampler, OriginalUV );    
}

float4 DrawSpritePS( float2 OriginalUV : TEXCOORD0 ) : COLOR
{
	return tex2D( DiffuseSampler, OriginalUV ) * g_Colour;    
}

float4 SplatPS() : COLOR
{
	return float4(0,1,0,1);
}

//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique DepthPass
{
    pass P0
    {          
        VertexShader = compile vs_1_1 RenderSceneVS();
        //PixelShader  = compile ps_2_0 RenderScenePS();
    }
}

technique CopyRenderTarget
{
    pass P0
    {          
        PixelShader  = compile ps_2_0 CopyPS();
    }
}

technique DrawSprite
{
    pass P0
    {          
        PixelShader  = compile ps_2_0 DrawSpritePS();
    }
}

technique Splat
{
    pass P0
    {          
        PixelShader  = compile ps_2_0 SplatPS();
    }
}
