//-----------------------------------------------------------------------------
// Global variables
//-----------------------------------------------------------------------------

texture g_sourceTexture;
texture g_accumTexture;

float g_deltaTime = 0.5;

//-----------------------------------------------------------------------------
// Texture samplers
//-----------------------------------------------------------------------------
sampler SourceSampler = 
sampler_state
{
    Texture = <g_sourceTexture>;
    MinFilter = POINT;  
    MagFilter = POINT;

    AddressU = Clamp;
    AddressV = Clamp;
};

sampler AccumSampler = 
sampler_state
{
    Texture = <g_accumTexture>;
    MinFilter = POINT;  
    MagFilter = POINT;

    AddressU = Clamp;
    AddressV = Clamp;
};

//-----------------------------------------------------------------------------
// Name: InvertPS 
// Type: Pixel shader                                      
// Desc: 
//-----------------------------------------------------------------------------
float4 AccumPS( float2 OriginalUV : TEXCOORD0 ) : COLOR
{
    // Add (new image * time) to  (prev accum image * (1-time)) and store in current accum image
	
	float3 vOutput = tex2D( AccumSampler, OriginalUV ) * (1-g_deltaTime);
	
	vOutput += tex2D( SourceSampler, OriginalUV ) * g_deltaTime;
	
    return float4(vOutput,0);
}

//-----------------------------------------------------------------------------
// Name: CopyPS 
// Type: Pixel shader                                      
// Desc: 
//-----------------------------------------------------------------------------
float4 CopyPS( float2 OriginalUV : TEXCOORD0 ) : COLOR
{
	return tex2D( SourceSampler, OriginalUV );
}

//-----------------------------------------------------------------------------
// Name: RenderScene
// Type: Technique                                     
// Desc: 
//-----------------------------------------------------------------------------
technique RenderScene
{
    pass P0
    {        
        PixelShader = compile ps_2_0 AccumPS();
    }
    
    pass P1
    {        
        PixelShader = compile ps_2_0 CopyPS();
    }
}


