float4x4 world_IT;

struct VertOut
{
	half4 hPosition	:POSITION;	
	half2 texCoord	:TEXCOORD;	
	half3 wPosition	:TEXCOORD1;	
	half3 Normal	:TEXCOORD2;
	half3 Tangent   : TEXCOORD3;	 // model space tangent vector
    half3 Binormal  : TEXCOORD4;	 // model space binormal vector
};

VertOut deaultVS(half4 position : POSITION,
		half3 normal:NORMAL,
		half3 Tangent   : TEXCOORD1, 	 
		half2 texCoord : TEXCOORD0,		
		uniform float4x4 worldViewProj,
		uniform float4x4 world)
{
  VertOut OUT;
  OUT.hPosition = mul(worldViewProj, position);  
  OUT.texCoord = texCoord;
  OUT.wPosition = mul(world, position).xyz;
  OUT.Normal = normal;
  OUT.Tangent = Tangent;  
  OUT.Binormal = cross(Tangent, normal); 
  return OUT;    
}

half4 deaultPS(VertOut IN,
				uniform sampler2D Texture : register(s0),
				uniform sampler2D NormalMap : register(s1),
				uniform half3 lightPosition,
				uniform half3 cameraPos,
				uniform half4 ambientColor,
				uniform half4 diffuseColor,
				uniform half4 specularColor,
				uniform half shininess				
				):COLOR
{
	half4 Color = half4(1,1,1,1);	

///get normal
	float3x3 ModelToTangent = float3x3(IN.Tangent, IN.Binormal, IN.Normal); 
	//float3x3 ModelToTangent = TransfModelToTangent(IN.Tangent, IN.Binormal, IN.Normal );
    half3 tNormal = tex2D(NormalMap, IN.texCoord).rgb;     	
   
   
    half3 wNormal =mul(tNormal, ModelToTangent );
    //wNormal = IN.Normal;
    wNormal = normalize(mul( wNormal, world_IT ));

///shading

	half3 V = -normalize( cameraPos - IN.wPosition);
	half3 light = lightPosition;
	half3 L = normalize(light);
	half3 H = normalize(L + V);
	half4 lighting = lit(dot(wNormal, L),dot(wNormal, H), shininess);
		
	Color = tex2D(Texture, IN.texCoord) * (lighting.y * diffuseColor + ambientColor)
					+ lighting.z * specularColor; 
	//Color = float4(wNormal,1);
	return Color;
}


half4 doubleTexturePS(VertOut IN,
				uniform sampler2D baseTexture : register(s0),
				uniform sampler2D paintTexture : register(s1),
				uniform sampler2D NormalMap : register(s2),
				uniform half3 lightPosition,
				uniform half3 cameraPos,
				uniform half4 ambientColor,
				uniform half4 diffuseColor,
				uniform half4 specularColor,
				uniform half shininess,
				uniform float2 texUVmult				
				):COLOR
{
	half4 Color = half4(1,1,1,1);
	
	float2 baseTexCoord = 	IN.texCoord * texUVmult;

///get normal
	float3x3 ModelToTangent = float3x3(IN.Tangent, IN.Binormal, IN.Normal); 
	//float3x3 ModelToTangent = TransfModelToTangent(IN.Tangent, IN.Binormal, IN.Normal );
    half3 tNormal = tex2D(NormalMap, baseTexCoord).rgb;     	
   
   
    half3 wNormal =mul(tNormal, ModelToTangent );
    //wNormal = IN.Normal;
    wNormal = normalize(mul( wNormal, world_IT ));

///shading

	half3 V = -normalize( cameraPos - IN.wPosition);
	half3 light = lightPosition;
	half3 L = normalize(light);
	half3 H = normalize(L + V);
	half4 lighting = lit(dot(wNormal, L),dot(wNormal, H), shininess);
	
	float4 baseColor = tex2D(baseTexture, baseTexCoord);
	float4 paintColor = tex2D(paintTexture, IN.texCoord);
	float4 texColor = baseColor + paintColor;
		
	Color =  texColor * (lighting.y * diffuseColor + ambientColor)
					+ lighting.z * specularColor; 
	//Color = float4(wNormal,1);
	return Color;
}