float4 readCubeMap(samplerCUBE cm, float3 coord)		
{
	float4 color = texCUBE( cm, float3(coord.xy, - coord.z) );
	return color;
}

float readDistanceCubeMap(samplerCUBE dcm, float3 coord)		
{
	float dist = texCUBE(dcm, float3(coord.xy, - coord.z)).r;
	if(dist == 0) dist = 40; ///sky
	return dist;
}

// This function is called several times.
float3 Hit( float3 x, float3 R, samplerCUBE mp )
{
	float rl = readDistanceCubeMap( mp, R);				// |r|
	
	float ppp = length( x ) /  readDistanceCubeMap( mp, x);			// |p|/|p|
	float dun = 0, pun = ppp, dov = 0, pov = 0;
	float dl = rl * ( 1 - ppp );							// eq. 2
	float3 l = x + R * dl;									// ray equation

	// iteration
	for( int i = 0; i < 2; i++ )	// 2 !!!!!!!!!!!!!!!!!!!!!!!
	{
		float llp = length( l ) / readDistanceCubeMap( mp, l);		// |l|/|l|
		if ( llp < 0.999f )									// undershooting
		{
			dun = dl; pun = llp;							// last undershooting
			dl += ( dov == 0 ) ? rl * ( 1 - llp ) :			// eq. 2
				( dl - dov ) * ( 1 - llp ) / ( llp - pov );	// eq. 3
		} else if ( llp > 1.001f )							// overshooting
		{
			dov = dl; pov = llp;							// last overshooting
			dl += ( dl -dun ) * ( 1 - llp ) / ( llp - pun );// eq. 3
		}
		l = x + R * dl;										// ray equation
	}
	return l;												// computed hit point
}

void BottleVS(float4 position : POSITION,
		out float3 wPos	: TEXCOORD1,				
		float2 texCoord : TEXCOORD0,
		out float2 otexCoord : TEXCOORD0,
		float3 normal   : NORMAL,
		out float3 mNormal  : TEXCOORD2,
		out float4 hPos : POSITION,		
		uniform float4x4 worldViewProj,
		uniform float4x4 world,
		uniform float4x4 worldIT)
{
 
  hPos = mul(worldViewProj, position);
  wPos = mul(world, position).xyz;  
  mNormal = mul(normal, worldIT);
 // mNormal = normal;
  otexCoord = texCoord;
}

//////////////
//Localized reflection
//////////////
void BottlePS(  float2 texCoord : TEXCOORD0, 
		float3 wPos	: TEXCOORD1,	
		float3 mNormal  : TEXCOORD2,
		uniform float3 cameraPos,
		uniform samplerCUBE CubeMap : register(s0),
		uniform samplerCUBE DistanceMap : register(s1),
		uniform float3 lastCenter,
		uniform float3 lightPosition,
		uniform float3 color,		
		out float4 Color :COLOR0)
{
	
	Color = float4(1,1,1,1);
	
	mNormal = normalize(mNormal);
	float3 RR, TT;	
	float3 mPos = wPos - lastCenter;
	float3 V = normalize(wPos - cameraPos);
	float3 R = normalize(reflect( V, mNormal));
	
	float3 T =  normalize(refract(V, mNormal, 0.9));
		
	RR = R;	TT = T;	
	
	RR = Hit(mPos, R, DistanceMap);
	TT = Hit(mPos, T, DistanceMap);
	
	float4 reflectcolor = readCubeMap(CubeMap, RR );		
	float4 refractcolor = readCubeMap(CubeMap, TT );		
	
	float cos_theta = -dot(V, mNormal);
	float sFresnel = 0.2;
	float F = (sFresnel + pow(1-cos_theta, 5.0f) * (1-sFresnel)); 

	Color = (F * reflectcolor + (1-F) * refractcolor * float4(color,1)) ;
	
	half3 light = lightPosition; 
	V = -V;
	half3 L = normalize(light);
	half3 H = normalize(L+V);
	half4 lighting = lit(dot(mNormal, L),dot(mNormal, H), 100);
	
	Color = (0.7 + lighting.y) * Color + lighting.z;
}


float4 BottlePhotonMapPS(  float2 texCoord : TEXCOORD0, 
		float3 wPos	: TEXCOORD1,	
		float3 mNormal  : TEXCOORD2,
		uniform float3 cameraPos,
		uniform samplerCUBE DistanceMap : register(s0),
		uniform float3 lastCenter):COLOR0
{
	
	float4 Color = float4(1,1,1,1);
	
	mNormal = normalize(mNormal);
	float3 newTexCoord;	
	float3 mPos = wPos - lastCenter;
	float3 V = normalize(wPos - cameraPos);
	float3 R = normalize(refract( V, mNormal, 0.9 ));
		
	newTexCoord = R;	
	
	newTexCoord = Hit(mPos, R, DistanceMap);
		
	Color = float4(normalize(newTexCoord),1);
	
	//if(dot(V,mNormal)>0)
	//{
	//	Color = float4(1,0,0,0);		
	//}		
	return Color;
}