struct VS_OUT
{
	float4 hPosition	: POSITION;
	float4 texCoord		: TEXCOORD0;
	float4 color		: COLOR0;
};

VS_OUT SpriteVS(float4 position : POSITION,	
		float4 texCoord : TEXCOORD0,
		float4 color 	: COLOR0,
		uniform float4x4 worldView,
		uniform float4x4 Proj,
		uniform float4x4 worldViewProj)
{
  VS_OUT OUT;

   //texCoord.y = 1.0 - texCoord.y;
   float2 offset = texCoord.zw;
   float4 cPosition = mul(worldView, position);
   cPosition.xy += offset;
   
	OUT.hPosition = mul( Proj, cPosition );
   OUT.texCoord = texCoord;
   OUT.color = float4(offset,1,1.0);


  return OUT;
}


float4 SpritePS(VS_OUT IN ,
		uniform sampler2D colorTexture : register(s0)):COLOR
{

	return tex2D( colorTexture, IN.texCoord.xy) * IN.color;
}






//////////-----------------------------------------


float farplane = 1000.0; //far plane
float nearplane = 0.1; //far plane
float width = 800;
float height = 600;

struct SBB_VS_OUT
{
	float4 hPosition	: POSITION;
	float4 texCoord		: TEXCOORD0;
	float3 P		: TEXCOORD1;
	float3 Q		: TEXCOORD2;
	float r			: TEXCOORD3;
	float2 screenCoord	: TEXCOORD4;	
	float4 color		: COLOR0;
};

SBB_VS_OUT SBB_SpriteVS (float4 position : POSITION,	
		float4 texCoord : TEXCOORD0,
		float4 color 	: COLOR,
		uniform float4x4 worldView,
		uniform float4x4 Proj,
		uniform float4x4 worldViewProj)
{
	SBB_VS_OUT OUT;
  
	float2 offset = texCoord.zw;
	float4 cPosition;   
	float4 wPosition = position;    
	cPosition = mul(worldView, wPosition);	
	OUT.P = cPosition.xyz;
	OUT.P.z = - 1 * OUT.P.z;
	cPosition.xy += offset;				
	OUT.Q = cPosition.xyz;	
	OUT.Q.z = OUT.P.z;
	OUT.r = abs(texCoord.z);		

   /*texCoord.y = 1.0 - texCoord.y;
   float2 offset = texCoord.xy * 2.0 - 1.0;
   float4 cPosition = mul(worldView, position);
   OUT.P = cPosition.xyz;
   OUT.P.z = - 1 * OUT.P.z; // - texCoord.w;
   cPosition.xy += offset * texCoord.w;
   OUT.Q = cPosition.xyz;
   OUT.Q.z = OUT.P.z;
   OUT.r = texCoord.w;*/
  
   OUT.hPosition = mul( Proj, cPosition );
   OUT.screenCoord =  (OUT.hPosition.xy / OUT.hPosition.w + 1.0) / 2.0;
   OUT.screenCoord.y = 1.0 - OUT.screenCoord.y;
   OUT.screenCoord += float2(0.5/width, 0.5/height);   
   
   OUT.texCoord = texCoord;
   OUT.color = color;


  return OUT;
} 


float4 SBB_SpritePS(SBB_VS_OUT IN ,
	//	in screenCoord : VPOS,
		uniform sampler2D colorTexture : register(s0),
		uniform sampler2D DepthMap : register(s1)
		,uniform sampler2D PlanckMap : register(s2),
		uniform sampler2D gradTex : register(s3)
		) : COLOR
{
	float4 Color = IN.color;
	float alpha = 0;
	
	
	float d = length( IN.Q - IN.P );
	float Zs;
	
	if( d < IN.r )
	{	 
		float w = sqrt( IN.r * IN.r - d * d );
		alpha = w / IN.r;
		//alpha *= pow( (IN.r-d) / IN.r , 2);
	
		float F = IN.Q.z - w;
		float B = IN.Q.z + w;	 

		Zs = tex2D( DepthMap, IN.screenCoord ).r;
		if(Zs == 0) Zs = farplane;
		float ds = min( Zs, B ) - max( nearplane, F );	 
		
		alpha *=  ds / w * 0.5;	
	}
	
	Color.a = saturate(alpha) * tex2D( colorTexture, IN.texCoord.xy).r ;
	Color.a *= IN.color.a;
	Color.rgb = tex2D( PlanckMap, Color.aa).rgb;
	Color.a *= tex2D(gradTex, IN.texCoord.xy).r;
	
	
	return Color; 
}


