struct VertOut
{
	float4 hPosition	:POSITION;	
	float2 texCoord		:TEXCOORD;	
	float3 wPosition	:TEXCOORD1;
	float3 wNormal		:TEXCOORD2;	
};


VertOut deaultVS(float4 position : POSITION,
		float3 normal:NORMAL,
		float2 texCoord : TEXCOORD0,
		uniform float4x4 world_IT,
		uniform float4x4 worldViewProj,
		uniform float4x4 world)
{
  VertOut OUT;
  OUT.texCoord = texCoord;
  OUT.hPosition = mul(worldViewProj, position);  
  OUT.wPosition = mul(world, position).xyz;
  OUT.wNormal = mul( normal, world_IT);
  //OUT.wNormal = normal;
  return OUT;    
}

float4 deaultPS(VertOut IN,
				uniform samplerCUBE CubeMap : register(s1),
				uniform sampler2D Texture : register(s0),
				uniform float3 cubeMapCameraPosition):COLOR
{
	float4 Color = float4(1,1,1,1);	
	
	float3 dir = IN.wPosition - cubeMapCameraPosition;
	float4 shadow = texCUBE(CubeMap, float3(dir.xy,-dir.z) );
			
	Color = tex2D(Texture, IN.texCoord) * (1.0- shadow);
		
	return Color;
}


float4 deault2PS(VertOut IN,
				uniform samplerCUBE CubeMap : register(s0),
				uniform float3 cubeMapCameraPosition,
				uniform float3 lightPosition,
				uniform float3 cameraPos
				):COLOR
{
	float4 Color = float4(1,1,1,1);	
	
	float3 dir = IN.wPosition - cubeMapCameraPosition;
	float4 shadow = texCUBE(CubeMap, float3(dir.xy,-dir.z) );
	
	IN.wNormal = normalize(IN.wNormal);
	float3 V = normalize(IN.wPosition - cameraPos);
	float3 L = normalize(lightPosition - IN.wPosition);
	float3 H = normalize(L + V);
	float4 lighting = lit(dot(IN.wNormal, L),dot(IN.wNormal, H), 80);
	
			
	Color = (1.0 - shadow ) *  lighting.y * float4(0.4, 0.7, 0.6, 1) + lighting.z;
		
	return Color;
}