
int CUBEMAP_SIZE = 256;
int RATE = 32;
int nFace;

float4 readCubeMap(samplerCUBE cm, float3 coord)		
{
	float4 color = texCUBE( cm, float3(coord.xy, coord.z) );
	return color;
}


struct VS_INPUT {           // vertex shader input
    float4 Position : POSITION;
};

struct VS_OUTPUT {          // vertex shader output, pixel shader input
    float4 hPosition : POSITION;
    float2 Position  : TEXCOORD0;
};

VS_OUTPUT ReduceTextureVS(VS_INPUT IN) {
	VS_OUTPUT OUT;
    OUT.hPosition = IN.Position;
    OUT.Position = IN.Position.xy;
    return OUT;
}

float4 ReduceTexturePS(VS_OUTPUT IN,
						uniform samplerCUBE EnvironmentMapSampler : register(s0) ) : COLOR
{  
	RATE = 32;
	CUBEMAP_SIZE = 256;
	
    float4 color = 0;
    // color += texCUBE( EnvironmentMapSampler, Tex );
    float3 dir;
  
   for (int i = 0; i < RATE; i++)
     for (int j = 0; j < RATE; j++)
    {
		float2 pos;
		pos.x = IN.Position.x + (2*i + 1)/(float)CUBEMAP_SIZE;
		pos.y = IN.Position.y - (2*j + 1)/(float)CUBEMAP_SIZE;	// y=-u

		// "scrambling"
		if (nFace == 0)	dir = float3(1, pos.y, -pos.x);
		if (nFace == 1) dir = float3(-1, pos.y, pos.x);
		if (nFace == 2) dir = float3(pos.x, 1, -pos.y);
		if (nFace == 3) dir = float3(pos.x, -1, pos.y);
		if (nFace == 4) dir = float3(pos.xy, 1);
		if (nFace == 5) dir = float3(-pos.x, pos.y,-1);

		color += readCubeMap( EnvironmentMapSampler, dir);
    }
    //return float4(IN.Position.xy,1,1);
	return color / (RATE*RATE);	
	
}