struct VS_OUT
{
	float4 hPosition	: POSITION;
	float2 texCoord		: TEXCOORD0;	
};

VS_OUT defaultVS(float4 position : POSITION,	
				float4 texCoord : TEXCOORD0)
{
	VS_OUT OUT;
  
	OUT.hPosition = float4(sign(position.xy),0,1);
	
	OUT.texCoord = (float2(OUT.hPosition.x,
							- OUT.hPosition.y) + 1.0) / 2.0;
	
   return OUT;
}


float4 defaultPS(VS_OUT IN,
		uniform sampler2D Texture: register(s0)
		 ):COLOR
{	

	/*float intens = length(tex2D(Texture,IN.texCoord ).rgb) / sqrt(3.0);
	return float4(intens,intens,intens,1);*/
	
	float4 sample = tex2D(Texture,IN.texCoord );
	if (sample.r + sample.g + sample.b < 1.7f) sample = float4(0,0,0,0);
	return sample;
	
	//return tex2D(Texture,IN.texCoord ).b;
}

float4 BlackPS(VS_OUT IN):COLOR
{
	return float4(0,0,0,1);
}

float4 GlowCutPS(VS_OUT IN,
		uniform float width,
		uniform float height,
		uniform sampler2D Texture: register(s0)
		,uniform sampler2D LastTexture: register(s1)
		 ):COLOR
{	

	/*float intens = length(tex2D(Texture,IN.texCoord ).rgb) / sqrt(3.0);
	return float4(intens,intens,intens,1);*/
	IN.texCoord += float2(0.5/width, 0.5/height);
	float4 sample = tex2D(Texture,IN.texCoord );
	float luminance = dot(sample.rgb, float3(1.0, 4.5907, 0.0601));
	if (luminance < 5.0) sample = float4(0,0,0,0);
	//if (sample.r + sample.g + sample.b < 1.7f) sample = float4(0,0,0,0);
	
	float alpha = 0.06;
	sample = sample * alpha + tex2D(LastTexture, IN.texCoord) * (1.0 - alpha);
	
	return sample;
}

half4 LuminancePS(VS_OUT IN,
		uniform half width,
		uniform half height,
		uniform sampler2D Texture: register(s0)
		):COLOR
{	

	IN.texCoord += half2(0.5/width, 0.5/height);
	half4 sample = tex2D(Texture,IN.texCoord );
	
	// D65 white conversion and weighting
	half avg = sample.r * 0.21f + sample.g * 0.39f + sample.b * 0.4f;
	return half4(avg, 0, 0, 1);
}

float4 GlowAddPS(VS_OUT IN,
		uniform float width,
		uniform float height,
		uniform sampler2D Texture: register(s0),
		uniform sampler2D GlowTexture: register(s1)
		 ):COLOR
{	
	IN.texCoord += float2(0.5/width, 0.5/height);
	/*float intens = length(tex2D(Texture,IN.texCoord ).rgb) / sqrt(3.0);
	return float4(intens,intens,intens,1);*/
	//return 1;
	return tex2D(Texture,IN.texCoord ) + tex2D(GlowTexture,IN.texCoord ) ;
}

float4 ToneMapPS(VS_OUT IN,
		uniform half width,
		uniform half height,
		uniform half Gain,
		uniform sampler2D Scene: register(s0),
		uniform sampler2D AvrLuminanceTexture: register(s1),
		uniform sampler2D LuminanceTexture: register(s2)
		 ):COLOR
{	
	IN.texCoord += half2(0.5/width, 0.5/height);
	
	// Automatic key calculation
	//half Key = 1.03f - 2.0f / (2.0f + log10(tex2D(AvrLuminanceTexture, IN.texCoord).r + 1.0f));	
	half Key = 1 / (tex2D(AvrLuminanceTexture, IN.texCoord).r / 1 + tex2D(AvrLuminanceTexture, IN.texCoord).r);
	//return 1 / Key;
	// Relative luminance
	half RelLum =  Key* tex2D(LuminanceTexture, IN.texCoord).r / 
						  tex2D(AvrLuminanceTexture, IN.texCoord).r;
	half Lum = RelLum / (1 + RelLum);
	// Color weghting
	half4 Color = tex2D(Scene, IN.texCoord) * Lum;
	// Gamma correction
	
	//Color = pow(Color * half4(1.05f, 0.97f, 1.27f, 1.0f), Gain);
	return Color;

}

float4 GlowBlurHPS(VS_OUT IN,
		uniform float Stretch,
		uniform float width,
		uniform float height,
		uniform sampler2D Texture: register(s0)) : COLOR {
	float2 tex0 = IN.texCoord + float2(0.5/width, 0.5/height);
	float4 texLookUp_h;
			
	/*texLookUp_h =	 tex2D(Texture, float2(tex0.x-(3.86979f*Stretch/width), tex0.y)) +
					 tex2D(Texture, float2(tex0.x-(1.72291f*Stretch/width ), tex0.y)) +
					 tex2D(Texture, tex0) +
					 tex2D(Texture, float2(tex0.x+(1.72291f*Stretch/width), tex0.y)) +
					 tex2D(Texture, float2(tex0.x+(3.86979f*Stretch/width), tex0.y));*/
	
	texLookUp_h =	 tex2D(Texture, float2(tex0.x-(2.0*Stretch/width), tex0.y)) +
					 tex2D(Texture, float2(tex0.x-(1.0*Stretch/width ), tex0.y)) +
					 tex2D(Texture, tex0) +
					 tex2D(Texture, float2(tex0.x+(1.0*Stretch/width), tex0.y)) +
					 tex2D(Texture, float2(tex0.x+(2.0*Stretch/width), tex0.y));

	return texLookUp_h / 5.0 ;
	//return texLookUp_h /5;
}

float4 GlowBlurVPS(VS_OUT IN,
		uniform float Stretch,
		uniform float width,
		uniform float height,
		uniform sampler2D Texture: register(s0)) : COLOR {
	float2 tex0 = IN.texCoord + float2(0.5/width, 0.5/height);
	float4 texLookUp_v;
		
	/*texLookUp_v =    tex2D(Texture, float2(tex0.x, tex0.y-(3.86979f*Stretch/height)))+
					 tex2D(Texture, float2(tex0.x, tex0.y-(1.72291f*Stretch/height)))+
					 tex2D(Texture, tex0)+
					 tex2D(Texture, float2(tex0.x, tex0.y+(1.72291f*Stretch/height)))+
					 tex2D(Texture, float2(tex0.x, tex0.y+(3.86979f*Stretch/height)));*/

	texLookUp_v =    tex2D(Texture, float2(tex0.x, tex0.y-(2*Stretch/height)))+
					 tex2D(Texture, float2(tex0.x, tex0.y-(1*Stretch/height)))+
					 tex2D(Texture, tex0) +
					 tex2D(Texture, float2(tex0.x, tex0.y+(1*Stretch/height)))+
					 tex2D(Texture, float2(tex0.x, tex0.y+(2*Stretch/height)));
	
	return texLookUp_v / 5.0;
}

float4 CopyPS(VS_OUT IN,
		uniform float width,
		uniform float height,
		uniform sampler2D Texture: register(s0)) : COLOR 
		{
	IN.texCoord += float2(0.5/width, 0.5/height);
	return tex2D(Texture,IN.texCoord );
}


