//metal:
float3 n, k;	// R 700 nm, G 550 nm, B 435 nm 
float3 F0;
/*
	
	// copper	
		n = float3(0.21f, 0.96f, 1.17f);	
		k = float3(4.16f, 2.57f, 2.32f); }
	// gold
		n = float3(0.16f, 0.35f, 1.6f);		
		k = float3(3.98f, 2.71f, 1.92f); }
	// silver
		n = float3(0.142f, 0.124f, 0.158f);	
		k = float3(4.52f,  3.33f, 2.32f); }
	// alu
		n = float3(1.83f, 0.96f, 0.577f);
		k = float3(8.31f,  6.69f, 5.288f); }

*/	

// material constants
const float3 ambientMaterial= float3(0.3, 0.3, 0.3);
const float3 diffuseMaterial = float3(1.0, 1.0, 1.0);	
const float3 specularMaterial = float3(1.0, 1.0, 1.0);

//------------------------------------------------------------------------------------
void DISCARD_BY_TEX(float2 Tex)
{
	if (Tex.x > 1 || Tex.x < 0 || Tex.y > 1 || Tex.y < 0)
		discard;
}

//------------------------------------------
// Attenuation with the square of the distance
//------------------------------------------
float SQR(float x) { return x*x; }
float Attenuation(float3 Light)
{
	return 1.0 / dot(Light, Light);
}

//-----------------------------------------------------------------------------
// Illumination function used in shading: all input vectors are normalized
//-----------------------------------------------------------------------------
/*
float4 Illumination(float3 Light, float3 Normal, float3 View, float2 TexCoord, float Attenuation)
{
	// Blinn lighting
	float3 Half = normalize(Light + View);
	float Diffuse = dot(Normal, Light);
	float Specular = dot(Normal, Half);
	float4 Lighting = lit(Diffuse, Specular, 16);
	float4 Color= tex2D(ColorMapSampler, TexCoord);

	return float4(
		Lighting.x * ambientMaterial * Color +
		(Lighting.y * diffuseMaterial * Color +
		Lighting.z * specularMaterial) * Attenuation, 1);
}*/

//-----------------------------------------------------------------------------
// Computes transformation matrix from modeling to tangent space
//-----------------------------------------------------------------------------
float3x3 TransfModelToTangent( in  float3 Tangent, in float3 Binormal, in float3 Normal ) {
	float T2 = dot(Tangent, Tangent);
	float B2 = dot(Binormal, Binormal);
	float N2 = dot(Normal, Normal);
	float BT = dot(Binormal, Tangent);
	float det = B2 * T2 - BT * BT;

	return float3x3( (B2 * Tangent - BT * Binormal)/det, 
	                 (T2 * Binormal - BT * Tangent)/det, 
	                 Normal/N2 );
/*		                               		
	// simplified solution
	return float3x3(Tangent/T2, Binormal/B2, Normal/N2); 
*/
} 

float4 readCubeMap(samplerCUBE cm, float3 coord)		
{
	float4 color = texCUBE( cm, float3(coord.xy, - coord.z) );
	return color;
}

float readDistanceCubeMap(samplerCUBE dcm, float3 coord)		
{
	float dist = texCUBE(dcm, float3(coord.xy, - coord.z)).r;
	if(dist == 0) dist = 10000; ///sky
	return dist;
}

// This function is called several times.
float3 Hit( float3 x, float3 R, samplerCUBE mp )
{
	float rl = readDistanceCubeMap( mp, R);				// |r|
	
	float ppp = length( x ) /  readDistanceCubeMap( mp, x);			// |p|/|p|
	float dun = 0, pun = ppp, dov = 0, pov = 0;
	float dl = rl * ( 1 - ppp );							// eq. 2
	float3 l = x + R * dl;									// ray equation

	// iteration
	for( int i = 0; i < 6; i++ )	// 2 !!!!!!!!!!!!!!!!!!!!!!!
	{
		float llp = length( l ) / readDistanceCubeMap( mp, l);		// |l|/|l|
		if ( llp < 0.999f )									// undershooting
		{
			dun = dl; pun = llp;							// last undershooting
			dl += ( dov == 0 ) ? rl * ( 1 - llp ) :			// eq. 2
				( dl - dov ) * ( 1 - llp ) / ( llp - pov );	// eq. 3
		} else if ( llp > 1.001f )							// overshooting
		{
			dov = dl; pov = llp;							// last overshooting
			dl += ( dl -dun ) * ( 1 - llp ) / ( llp - pun );// eq. 3
		}
		l = x + R * dl;										// ray equation
	}
	return l;												// computed hit point
}

float4 metal_reflectivity(float3 L, float3 N, float3 V)
{
	
	
	float ctheta_in = dot(N,L);
	float ctheta_out = dot(N,V);

	float4 intens = 0;
	
	// F,P,G szmtsa
	if ( ctheta_in > 0 && ctheta_out > 0 )
	{
		float3 H = normalize(L + V);	// felezvektor
		float calpha = dot(N,H);
		float cbeta  = dot(H,L);
		
		float3 F = ( (n-1)*(n-1) + pow(1-cbeta,5) * 4*n + k*k) / ( (n+1)*(n+1) + k*k );

		float m = 0.8;
		float m2 = m*m;
		float PI = 3.14159f;

		float calpha2 = calpha*calpha;
		float salpha2 = 1-calpha2;
		
		float P = exp( -( salpha2 / calpha2 / m2 )) / (m2 * PI * calpha * calpha2);
		
		float f1 = 2*calpha*ctheta_out/cbeta;
		float f2 = 2*calpha*ctheta_in /cbeta;
		float G = min(1, min( f1, f2 )) / 4 / ctheta_in / ctheta_out;
		//float GG = 1 / (4*cbeta*cbeta);

		//F*P*G*ctheta_in		
		intens += float4(F, 1) * P * G * ctheta_in;
	}
	
	return 3*intens;
}

float3 expand(float3 v)
{
	return (v - 0.5) * 2;
}

float2 PARALLAX_MAPPING(sampler2D heightMap, float2 TexCoord, float3 View)
{
	float HEIGHT_SCALE = 0.06;
	float HEIGHT_BIAS = -0.12;
    float h = tex2D(heightMap, TexCoord).r * HEIGHT_SCALE + HEIGHT_BIAS;
    return TexCoord + h * View.xy / View.z;
} 

struct VS_INPUT {
    float4 Position  : POSITION;     // point in modeling space
    float2 TexCoord	 : TEXCOORD0;    // texture coordinates
    float3 Tangent   : TEXCOORD1;  	 // model space tangent vector
    float3 Normal    : NORMAL;		 // model space triangle normal vector
};

struct VS_OUTPUT {
    float4 hPosition : POSITION;     // point in normalized device space before homogeneous division
    float2 TexCoord  : TEXCOORD0;    // texture coordinates
    float3 Normal    : TEXCOORD1;	 // model space triangle normal vector
    float3 wPosition : TEXCOORD2;	 // model space tangent vector
	float3 Tangent   : TEXCOORD3;	 // model space tangent vector
    float3 Binormal  : TEXCOORD4;	 // model space binormal vector
}; 

VS_OUTPUT LocalizedBumpVS(VS_INPUT IN,
		uniform float4x4 worldViewProj,
		uniform float4x4 worldViewIT,
		uniform float4x4 world)
{
  VS_OUTPUT OUT;
  OUT.hPosition = mul(worldViewProj, IN.Position);
  OUT.wPosition = mul(world, IN.Position).xyz;  
  //OUT.Normal = mul(worldViewIT, IN.Normal);
  OUT.Normal = IN.Normal;
  OUT.TexCoord = IN.TexCoord;
  OUT.Tangent = IN.Tangent;  
  OUT.Binormal = cross(IN.Tangent, IN.Normal); 
  
  return OUT;
}

//////////////
//Localized reflection with bump
//////////////
/*
VS_OUTPUT BaseVS(VS_INPUT IN)
{
        VS_OUTPUT OUT;

		
		OUT.Tangent = IN.Tangent;
		OUT.Binormal = IN.Binormal;
		OUT.Normal = IN.Normal;
		
        // vertex position before homogenious division
        OUT.hPosition = mul(IN.Position, WorldViewProj);
		// tex coordinates passed to pixel shader
        OUT.TexCoord = IN.TexCoord0;

		return OUT;
} 
float4 BumpPS(VS_OUTPUT IN) : COLOR
{
  
    // get model space normal vector
	float3x3 ModelToTangent = TransfModelToTangent(IN.Tangent, IN.Binormal, IN.Normal );
    // get model space normal vector
    float3 tNormal = tex2D(BumpMapSampler, IN.TexCoord).rgb;
	// Normal vector should be transformed with the inverse transpose of TangentToModel
	// which is the transpose of ModelToTangent
    float3 mNormal = normalize( mul( tNormal, ModelToTangent ) );     
    
}
*/

void LocalizedBumpPS(  VS_OUTPUT IN,
		uniform float3 cameraPos,
		uniform samplerCUBE CubeMap : register(s0),
		uniform samplerCUBE DistanceMap : register(s1),
		uniform sampler2D NormalMap : register(s2),
		uniform sampler2D DisplacementMap : register(s3),
		uniform float3 lastCenter,
		uniform float3 lightPosition,		
		out float4 Color :COLOR0)
{
	// get model space normal vector
	float3x3 ModelToTangent = TransfModelToTangent(IN.Tangent, IN.Binormal, IN.Normal );
    // get model space normal vector
	
	//parallax
	/*
	float3 tView = mul(ModelToTangent, IN.wPosition ); 
    float2 ParallaxTex = PARALLAX_MAPPING(DisplacementMap, IN.TexCoord, tView);
    float3 tNormal = tex2D(NormalMap, ParallaxTex).rgb;	
    */ 
        
    float3 tNormal = tex2D(NormalMap, IN.TexCoord).rgb;    	
    float3 mNormal = normalize( mul( tNormal, ModelToTangent ) );
        
   //Color = float4(tex2D(DisplacementMap, IN.TexCoord).rgb, 1 + lastCenter.x * 0.000000001);
	Color = float4(1,1,1,1); 
	
	float3 RR, TT;	
	float3 mPos = IN.wPosition - lastCenter;
	float3 V = normalize(IN.wPosition - cameraPos);
	float3 R = (reflect( V, mNormal));
	
	float3 T = refract(V, mNormal, 0.9);
		
	RR = R;	TT = T;
	RR = Hit(mPos, R, DistanceMap);
	TT = Hit(mPos, T, DistanceMap);
	
	float4 reflectcolor = readCubeMap(CubeMap, RR );		
	float4 refractcolor = readCubeMap(CubeMap, TT );		
	
	float cos_theta = -dot(V, mNormal);
	float sFresnel = 0.4;
	float F = (sFresnel + pow(1-cos_theta, 5.0f) * (1-sFresnel));
    
    float3 L = normalize(lightPosition - IN.wPosition);
	float3 H = normalize(L+V);
	float4 lighting = lit(dot(mNormal, L),dot(mNormal, H), 30);
	Color = (F * reflectcolor + (1-F) * refractcolor)/* + lighting.z *1000*/;	
}


//////////////
//Metal
//////////////
void LocalizedMetalPS(  float2 texCoord : TEXCOORD0, 
		float3 wPos	: TEXCOORD1,	
		float3 mNormal  : TEXCOORD2,
		uniform float3 cameraPos,
		uniform samplerCUBE CubeMap : register(s0),
		uniform samplerCUBE DistanceMap : register(s1),
		uniform float3 lastCenter,
		uniform float3 lightPosition,				
		out float4 Color :COLOR0)
{
	
	Color = float4(1,1,1,1);
	
	mNormal = normalize(mNormal);
	float3 newTexCoord;	
	float3 mPos = wPos - lastCenter;
	float3 V = normalize(wPos - cameraPos);
	float3 R = normalize(reflect( V, mNormal));
		
	newTexCoord = R;	
	
	newTexCoord = Hit(mPos, R, DistanceMap);
	
	Color = readCubeMap(CubeMap, newTexCoord );	
	
	float ctheta_in = dot(mNormal,R);
	float ctheta_out = dot(mNormal,-V);

	float3 F = 0;
	
	// F,P,G szmtsa
	if ( ctheta_in > 0 && ctheta_out > 0 )
	{
		float3 H = normalize(R - V);	// felezvektor
		float cbeta  = dot(H,R);		
		//F = ( (n-1)*(n-1) + pow(1-cbeta,5) * 4*n + k*k) / ( (n+1)*(n+1) + k*k );
		//float3 F0 = ((n-1)*(n-1) + k*k) / ( (n+1)*(n+1) + k*k );
		//float3 F1 = float3(1.0f,1.0f,1.0f) - F0;
		F = F0 + (1-F0)*pow(1-cbeta,5);
	}
	
	//Color *= metal_reflectivity(R, mNormal, -V);
	
	Color = Color * float4(F,1);	
}
