///////depth map
struct VS_OUT
{
	float4 hPosition	: POSITION;
	float4 Position	: TEXCOORD0;
};

VS_OUT hDepthVS(float4 position : POSITION,	
		uniform float4x4 worldView,
		uniform float4x4 worldViewProj)
{
  
  VS_OUT OUT;
  OUT.hPosition = mul(worldViewProj, position);
  OUT.Position = mul(worldView, position);
  OUT.Position.z *= -1.0;
  return OUT;
}



float4 DepthPS(VS_OUT IN ):COLOR
{
	float dist = length(IN.Position.xyz);
	return float4(dist, dist, dist, 1);	
}

///////////////Shadow

struct VS_OUT_SHADOW
{
	float4 hPosition	: POSITION;
	float4 Position		: TEXCOORD0;
	float4 cPosition	: TEXCOORD1;
};

VS_OUT_SHADOW depthShadowVS(float4 position : POSITION,	
		uniform float4x4 world,
		uniform float4x4 worldView,
		uniform float4x4 worldViewProj)
{
  VS_OUT_SHADOW OUT;
  OUT.hPosition = mul(worldViewProj, position);
  OUT.Position = mul(world, position);
  OUT.cPosition = mul(worldView, position);
  return OUT;
}


float4 depthShadowPS(VS_OUT_SHADOW IN,
					uniform float4x4 lightView,
					uniform float4x4 lightViewProj,
					uniform float4x4 lightView2,
					uniform float4x4 lightViewProj2,
					uniform sampler2D depthShadowMap : register(s0),
					uniform sampler2D depthShadowMap2 : register(s1)):COLOR
{					
	float bias = 0.06;
	float4 shadowColor = float4(0.6, 0.6, 0.6, 1.0);

	float4 light1 = 1;
	float4 light2 = 1;
	float weight1 = 1;
	float weight2 = 1;
	
	float4 lightCamPos1 = mul(lightView, IN.Position);
	float d1 = length(lightCamPos1.xyz);	
	float4 lightScreenPos1 = mul(lightViewProj, IN.Position);
	lightScreenPos1 = lightScreenPos1 / lightScreenPos1.w ;	
	lightScreenPos1 = ( lightScreenPos1 + 1.0 ) / 2.0;
	lightScreenPos1.y = 1.0 - lightScreenPos1.y;
	float4 storedDepth1 = tex2D(depthShadowMap, lightScreenPos1.xy);
		if(storedDepth1.r + bias < d1)
			light1=0;
	
	
	float4 lightCamPos2 = mul(lightView2, IN.Position);
	float d2 = length(lightCamPos2.xyz);
	
			
	float4 lightScreenPos2 = mul(lightViewProj2, IN.Position);
	lightScreenPos2 = lightScreenPos2 / lightScreenPos2.w ;	

	if(abs(lightScreenPos2.x) < 0.99 && abs(lightScreenPos2.y) < 0.99 )
	{
		lightScreenPos2 = ( lightScreenPos2 + 1.0 ) / 2.0;
		lightScreenPos2.y = 1.0 - lightScreenPos2.y;
		float4 storedDepth2 = tex2D(depthShadowMap2, lightScreenPos2.xy);
			if(storedDepth2.r + bias < d2)
				light2=0;	
	}
	else
		weight2 = 0;
		
	weight1 = 1 - weight2;	
		
	return saturate((light1*weight1 + light2*weight2) + shadowColor);	
}

