float farplane = 100.0;
float nearplane = 0.1;

struct VS_OUT
{
	float4 hPosition	: POSITION;
	float4 Position	: TEXCOORD0;
};

VS_OUT hDepthVS(float4 position : POSITION,	
		uniform float4x4 worldView,
		uniform float4x4 worldViewProj)
{
  VS_OUT OUT;
  OUT.hPosition = mul(worldViewProj, position);
  OUT.Position = ( OUT.hPosition / OUT.hPosition.w + 1) / 2.0;
  return OUT;
}

VS_OUT cDepthVS(float4 position : POSITION,	
		uniform float4x4 worldView,
		uniform float4x4 worldViewProj)
{
  VS_OUT OUT;
  OUT.hPosition = mul(worldViewProj, position);
  OUT.Position = mul(worldView, position);
  OUT.Position.z *= -1.0;
  return OUT;
}


float4 DepthPS(VS_OUT IN ):COLOR
{
	return float4(IN.Position.z, IN.Position.z, IN.Position.z, 1);	
}
