

void deaultVS(half4 position : POSITION,
		out half3 wPos	: TEXCOORD1,				
		half2 texCoord : TEXCOORD0,
		out half2 otexCoord : TEXCOORD0,
		half3 normal   : NORMAL,
		out half3 mNormal  : TEXCOORD2,
		out half4 hPos : POSITION,		
		uniform float4x4 worldViewProj,
		uniform float4x4 world)
{
 
  hPos = mul(worldViewProj, position);
  wPos = mul(world, position).xyz;
  mNormal = normal;
  otexCoord = texCoord;

}




void deaultPS(  half2 texCoord : TEXCOORD0, 
		half3 wPos	: TEXCOORD1,	
		half3 mNormal  : TEXCOORD2,
		uniform samplerCUBE CubeMap : register(s0),
		uniform half3 cameraPos,
		out half4 Color :COLOR0)
{
	Color = float4(1,1,1,1);
	mNormal = normalize(mNormal);
	half3 V = normalize(wPos - cameraPos);
	half3 R = reflect( V, mNormal);	
	R.z *= -1;
		
	Color = texCUBE(CubeMap, R );
	
}