float4x4 world_IT;

float3x3 TransfModelToTangent( in  half3 Tangent, in half3 Binormal, in half3 Normal ) {
	half T2 = dot(Tangent, Tangent);
	half B2 = dot(Binormal, Binormal);
	half N2 = dot(Normal, Normal);
	half BT = dot(Binormal, Tangent);
	half det = B2 * T2 - BT * BT;

	return float3x3( (B2 * Tangent - BT * Binormal)/det, 
	                 (T2 * Binormal - BT * Tangent)/det, 
	                 Normal/N2 );
/*		                               		
	// simplified solution
	return float3x3(Tangent/T2, Binormal/B2, Normal/N2); 
*/
} 

struct VertOut
{
	half4 hPosition	:POSITION;	
	half2 texCoord		:TEXCOORD;	
	half3 wPosition	:TEXCOORD1;	
	half3 Normal		:TEXCOORD2;
	half3 Tangent   : TEXCOORD3;	 // model space tangent vector
    half3 Binormal  : TEXCOORD4;	 // model space binormal vector
};


VertOut deaultVS(half4 position : POSITION,
		half3 normal:NORMAL,
		half3 Tangent   : TEXCOORD1, 	 
		half2 texCoord : TEXCOORD0,		
		uniform float4x4 worldViewProj,
		uniform float4x4 world)
{
  VertOut OUT;
  OUT.texCoord = texCoord;
  OUT.hPosition = mul(worldViewProj, position);  
  OUT.wPosition = mul(world, position).xyz;
  OUT.Normal = normal;
  OUT.Tangent = Tangent;  
  OUT.Binormal = cross(Tangent, normal); 
  return OUT;    
}

half4 deaultPS(VertOut IN,
				uniform sampler2D Texture : register(s0),
				uniform sampler2D NormalMap : register(s1),
				uniform half3 lightPosition,
				uniform half3 cameraPos
				):COLOR
{
	half4 Color = half4(1,1,1,1);	
///get normal
	float3x3 ModelToTangent = float3x3(IN.Tangent, IN.Binormal, IN.Normal); 
	//float3x3 ModelToTangent = TransfModelToTangent(IN.Tangent, IN.Binormal, IN.Normal );
    half3 tNormal = tex2D(NormalMap, IN.texCoord).rgb;     	
   
   
    half3 wNormal =mul(tNormal, ModelToTangent );
    //wNormal = IN.Normal;
    wNormal = normalize(mul( wNormal, world_IT ));
///shading
	half3 V = normalize(IN.wPosition - cameraPos);
	half3 light = (lightPosition - IN.wPosition) / 200.0;
	half3 L = normalize(light);
	half3 H = normalize(L+V);
	half4 lighting = lit(dot(wNormal, L),dot(wNormal, H), 80);
	
	half4 ambient = float4(0.1, 0.1, 0.1, 1.0);
	
	Color = tex2D(Texture, IN.texCoord) * (lighting.y  /*+ ambient*/) + lighting.z * half4(0.3,0.3,0.3,1); 
	
	return Color;
}