
float readDistanceCubeMap(samplerCUBE dcm, float3 coord)		
{
	float dist = texCUBE(dcm, float3(coord.xy, - coord.z)).r;
	if(dist == 0) dist = 10000; ///sky
	return dist;
}

struct VertOut
{
	float4 hPosition	:POSITION;	
	float2 texCoord		:TEXCOORD;	
	float3 wPosition	:TEXCOORD1;	
};


VertOut deaultVS(float4 position : POSITION,
		float2 texCoord : TEXCOORD0,
		uniform float4x4 worldViewProj,
		uniform float4x4 world)
{
  VertOut OUT;
  OUT.texCoord = texCoord;
  OUT.hPosition = mul(worldViewProj, position);  
  OUT.wPosition = mul(world, position).xyz;
  return OUT;    
}

float4 deaultPS(VertOut IN,
				uniform samplerCUBE CubeMap : register(s0),
				uniform samplerCUBE distanceCube : register(s1),
				uniform float3 cubeMapCameraPosition,
				uniform float attenuation):COLOR
{
	float4 Color = float4(1,1,1,1);	
	
	float3 dir = IN.wPosition - cubeMapCameraPosition;
	float4 caustic = texCUBE(CubeMap, float3(dir.xy,-dir.z) );
	float mydist = length(dir);
	float dist = readDistanceCubeMap(distanceCube, dir);
	
	float EPSILON = 0.1;

	//if(mydist > dist + EPSILON) caustic = 0;
	 caustic *= max(attenuation - mydist, 0) / attenuation;
		
	Color = caustic;
		
	return Color;
}